"Idols of War" by "Victor Gijsbers"

The story headline is "An Interactive Dungeon Crawl (0.1.2 Public Alpha)".



Include Basic Help Menu by Emily Short.
Include Plurality by Emily Short.
Include Simple Chat by Mark Tilford.
Include Scheduled Activities by John Clemens.
[Include Conditional Undo by Jesse McGrew.]
Include Dice-lock by S John Ross.

Before doing anything: lock the dice.

Use no scoring, full-length room descriptions[ and undo prevention].

Use MAX_OBJ_PROP_COUNT of 128. [Because we define way more than 64  properties for persons/monsters!]
[Use MAX_PROP_TABLE_SIZE of 50000.]

Use MAX_STATIC_DATA of 300000.
[Use dynamic memory allocation of at least 30000.]

Use Default Forbid Exiting Conversations. [Simple Chat]


When play begins, seed the random-number generator with 23481.


Volume 1 - The System



Chapter 1.0.0.1 - Preliminaries


Section 1.0.0.1.1 - Dummy variables declared

[We are going to need a bunch of dummy variables during the calculations we will make. Since Inform 7 does not have a rigid global/local distinction - as far as I know, the only local variables are those which are declared in the names of activities - we will define them globally.]

The first dummy is a number that varies.
The second dummy is a number that varies.
The third dummy is a number that varies.
The fourth dummy is a number that varies.

The room dummy is a room that varies.

The monster dummy is a person that varies.

The thing dummy is a thing that varies.

The first dummy boolean is a truth state that varies.


Section 1.0.0.1.2 - Other global variables

[The combat boolean is a number that is 1 if the player is in combat, and 0 if she is not.]

The combat boolean is a number that varies. The combat boolean is 0.


Section 1.0.0.1.3 - Time

[Some of the actions we define should take no time; and we wish to ensure that examining, smelling, and so on do not take time either. This will allow the player to look around in combat, which is to be encouraged.]

Examining something is acting fast.
Taking inventory is acting fast.
Smelling is acting fast.
Smelling something is acting fast.
Looking is acting fast.
Looking under something is acting fast.
Listening is acting fast.
Listening to something is acting fast.
Thinking is acting fast.


First turn sequence rule: if acting fast, rule succeeds.

To take no time:
    (- meta = true; -).


Section 1.0.0.1.4 - The Status Line

[We want to show the current location on the left side; and the current level, blood and zeal of the player on the right side.]

Table of Fancy Status
left	central	right
"[bold type][location of the player][roman type]"	"[capital blood]: [status bar blood]/[permanent blood of the player]"	"[capital zeal]: [status bar zeal]/[permanent zeal of the player]"
"Favour: [favoured idols]"	"Disfavour: [disfavoured idols]"	"[status bar excitement]"
"Deadly Combat: [deadly combat status]"	"Next Beat: [first beat status]"	"Beat Bonus: [second beat status]"


Rule for constructing the status line:
	fill status bar with Table of Fancy Status;
	rule succeeds. 

To say status bar excitement:
	if the excitement of the player is Frantic or the excitement of the player is Frenzied, say "[bold type]";
	say "[excitement of the player]";
	say "[roman type]".


To say status bar blood:
	now first dummy is permanent blood of the player divided by 4;
	if the blood of the player is not greater than first dummy, say "[bold type]";
	say "[blood of the player][roman type]".

To say status bar zeal:
	now first dummy is permanent zeal of the player divided by 4;
	if the zeal of the player is not greater than first dummy, say "[bold type]";
	say "[zeal of the player][roman type]".



Section 1.0.0.1.5 - Printing Styles

Printing style is a kind of value. The printing styles are printing-normal and printing-fiery.

The printing state is a printing style that varies. The printing state is usually printing-normal.







Book 1.1 - The Combat System


Chapter 1.1.0.1 - Combat Stats of the Characters


Section 1.1.0.1.1 - Blood

To say capital blood:
	say "Blood".

To say blood:
	say "blood".

A person has a number called blood. The blood of a person is usually 10. [Blood is a measure of health.]

Definition: A person is alive if its blood is 1 or more. Definition: A person is killed if its blood is 0 or less. [Once blood drops to zero, you are dead. This holds true for both the player and his enemies.] 

[Understand the alive property as describing a monster.]


A person has a number called permanent blood. [The maximum you can regain with healing.]

When play begins:
    repeat with the patient running through people begin;
        change the permanent blood of the patient to the blood of the patient;
    end repeat.

[We set the permanent blood of each individual to the blood it has at the beginning of the game. If we wish any character to start the game wounded or super-healthy, we will have to manually override this process.]

To restore the blood of (patient - a person): change the blood of the patient to the permanent blood of the patient. 

To heal (patient - a person) for (health - a number) blood:
	now the first dummy is the permanent blood of the patient minus the blood of the patient;
	if health is less than the first dummy, now the first dummy is health;
	increase the blood of the patient by the first dummy;
	say the first dummy.


A person has a number called gained blood. [This is the amount of blood the player will get when killing the character.]

When play begins:
	repeat with the patient running through people begin;
        	change the gained blood of the patient to a random number between 1 and the permanent blood of the patient;
		if the patient is summoned, now the gained blood of the patient is 0; 
	end repeat.



Section 1.1.0.1.2 - Zeal

To say capital zeal:
	say "Zeal".

To say zeal:
	say "zeal".


A person has a number called zeal. The zeal of a person is usually 0. 



A person has a number called permanent zeal. [The maximum you can regain through rituals.]

When play begins:
    repeat with the patient running through people begin;
        change the permanent zeal of the patient to the zeal of the patient;
    end repeat.

[We set the permanent blood of each individual to the zeal it has at the beginning of the game. If we wish any character to start the game tired or over-zealous, we will have to manually override this process.]

To restore the zeal of (patient - a person): change the zeal of the patient to the permanent zeal of the patient.


Section 1.1.0.1.3 - Concentration

[Concentration allows you to hit more accurately, while doing more damage. With concentration 1: +1 to hit. With concentration 2: + 2 to hit, +1 to damage. With concentration 3 or more: +3 to hit, + 2 to damage.]

A person has a number called concentration. The concentration of a person is usually 0.

An attack modifiers rule (this is the concentration attack modifier rule):
	if the concentration of the global attacker is greater than 0 begin;
		if the concentration of the global attacker is 1, now the first dummy is 2;
		if the concentration of the global attacker is 2, now the first dummy is 4;
		if the concentration of the global attacker is 3, now the first dummy is 8;
		if the global attacker is at parry begin;
			increase the first dummy by the concentration of the global attacker;
			decrease the first dummy by 1; [an additional +0/+1/+2]
		end if;
		say " + ", the first dummy, " (concentration)[run paragraph on]";
		increase the to-hit modifier by the first dummy;
	end if;

Section 1.1.0.1.4 - Melee, Mind, Defence

[These are pretty self-explanatory. You normally hit if 1d6 + melee is _higher_ than the defence of your enemy.]

A person has a number called melee. The melee of a person is usually 0. 

A person has a number called mind. The mind of a person is usually 0.

A person has a number called defence. The defence of a person is usually 7.


Section 1.1.0.1.5 - Separation

[Separated persons cannot attack each other. Those who are separation-privileged are exempt from this restriction.]

[This will be obsolete once the sublocations are implemented]

A person is either separated or not separated. A person is usually not separated.

A person is either separation-privileged or not separation-privileged. A person is usually not separation-privileged. 

A whether attacking begins rule (this is the separation rule):
	if the global attacker is separated and the global attacker is not separation-privileged begin;
		if the global defender is the player, say "[The global attacker] cannot reach you.";
		if the global defender is not the player, say "[The global attacker] cannot reach [the global defender].";
		stop;
	end if;
	if the global defender is separated begin;
		if the global defender is the player, say "[The global attacker] cannot reach you.";
		if the global defender is not the player, say "[The global attacker] cannot reach [the global defender].";
		stop;
	end if.


Section 1.1.0.1.6 - Deadly Combat

The deadly combat bonus is a number that varies. The deadly combat bonus is usually 0. [Whenever a combat round goes by in which nobody deals damage, the deadly combat bonus increases by 1. Whenever a combat round goes by in which somebody deals damage, it goes down by 1 to a minimum of 0. The deadly combat bonus is added to everyone;s to-hit modifier.]

The deadly combat boolean is a truth state that varies. The deadly combat boolean is usually true.

Every turn when a hostile alive monster is enclosed by the location (this is the global combat variables rule):
	if the deadly combat boolean is true, increase the deadly combat bonus by 1;
	if the deadly combat boolean is false, decrease the deadly combat bonus by 2;
	if the deadly combat bonus is less than 0, now the deadly combat bonus is 0;
	if the deadly combat bonus is greater than 5, now the deadly combat bonus is 5;
	if no hostile alive monster was enclosed by the location, now the deadly combat bonus is 0;
	do the tutorial deadly combat check;
	now the deadly combat boolean is true.

The global combat variables rule is listed last in the every turn rules.

Every turn when no hostile alive monster is enclosed by the location:
	now the deadly combat bonus is 0.

To say deadly combat status:
	if the deadly combat bonus is 0, say "-";
	if the deadly combat bonus is not 0, say "+ [deadly combat bonus]".

An attack modifiers rule (this is the deadly combat attack bonus rule):
	if the deadly combat bonus is greater than 0 begin;
		say " + ", the deadly combat bonus, " (deadly combat)[run paragraph on]";
		 increase the to-hit modifier by the deadly combat bonus;
	end if.


Section 1.1.0.1.7 - Beat

A room has a number called location beat. The location beat of a room is normally 0. A room has a number called location beat strength. The location beat strength of a room is normally 0.

The beat is a number that varies. The beat is 0.

The beat count is a number that varies. The beat count is 0.

The beat strength is a number that varies. The beat strength is 0.


[This makes the beat beat]

Last every turn when the beat is not 0:
	decrease the beat count by 1;
	if the beat count is less than 0, now the beat count is the beat.

[This sets the beat upon entering a new room]

After going:
	now the beat is the location beat of the location;
	now the beat count is the beat;
	increase the beat count by 1; [because it'll be decreases by 1 at the end of the moving turn.]
	now the beat strength is the location beat strength of the location;
	continue the activity.



[These routines are for the status bar.]

To say first beat status:
	if the beat is 0 begin;
		say "-";
	otherwise;
		if the beat count is 0, say "[bold type]now[roman type]";
		if the beat count is 1, say "[the beat count] turn";
		if the beat count is greater than 1, say "[the beat count] turns";
	end if.

To say second beat status:
	if the beat is 0 or the beat strength is 0, say "-";
	if the beat is not 0 and the beat strength is not 0, say the beat strength.


[We want to be able to assign random beat to rooms when the game starts.]

A room is either rb, hrb, or nrb. A room is usually rb.

When play begins:
	repeat with patient running through rooms begin;
		if patient is in Tutorial, now patient is nrb;
		if patient is rb and the location beat of the patient is 0 begin;
			now first dummy is a random number between 2 and 6;
			now second dummy is a random number between 0 and 3;
			if second dummy is not 0, now the location beat of patient is first dummy;
			now first dummy is a random number between 1 and 3;
			now second dummy is a random number between 1 and 3;
			now the location beat strength of patient is first dummy;
			if first dummy is greater than second dummy, now the location beat strength of patient is second dummy;
		end if;
		if patient is hrb and the location beat of the patient is 0 begin;
			now first dummy is a random number between 1 and 5;
			if second dummy is not 0, now the location beat of patient is first dummy; [bug]
			now first dummy is a random number between 2 and 6;
			now second dummy is a random number between 2 and 6;
			now the location beat strength of patient is first dummy;
			if first dummy is greater than second dummy, now the location beat strength of patient is second dummy;
		end if;
	end repeat.


Section 1.1.0.1.8 - Excitement

Excitement is a kind of value. The excitements are Serene, Calm, Animated, Excited, Agitated, Frantic, Frenzied and Lost.

A person has an excitement. A person is usually animated.

A person has an excitement called the base excitement state. The base excitement state of a person is usually animated.

The player is calm. The base excitement state of the player is calm. 

An attack modifiers rule (this is the excitement attack bonus rule):
	if the global attacker is serene begin;
		say " - 1 (serene)[run paragraph on]";
		decrease the to-hit modifier by 1;
	end if;
	if the global attacker is agitated begin;
		say " + 1 (agitated)[run paragraph on]";
		increase the to-hit modifier by 1;
	end if;
	if the global attacker is frantic begin;
		say " + 2 (frantic)[run paragraph on]";
		increase the to-hit modifier by 2;
	end if;
	if the global attacker is frenzied begin;
		say " + 4 (frenzied)[run paragraph on]";
		increase the to-hit modifier by 4;
	end if.

To calculate the excitement damage bonus of (the subject - a person):
	if the subject is serene begin;
		say " - 3 (serene)[run paragraph on]";
		decrease the damage modifier by 3;
	end if;
	if the subject is calm begin;
		say " - 1 (calm)[run paragraph on]";
		decrease the damage modifier by 1;
	end if;
	if the subject is excited begin;
		say " + 1 (excited)[run paragraph on]";
		increase the damage modifier by 1;
	end if;
	if the subject is agitated begin;
		say " + 2 (agitated)[run paragraph on]";
		increase the damage modifier by 2;
	end if;
	if the subject is frantic begin;
		say " + 4 (frantic)[run paragraph on]";
		increase the damage modifier by 4;
	end if;
	if the subject is frenzied begin;
		say " + 8 (frenzied)[run paragraph on]";
		increase the damage modifier by 8;
	end if.

An always-present attack modifiers rule (this is the excitement defence bonus rule):
	if the global defender is serene begin;
		say " - 1 (opponent serene)[run paragraph on]";
		decrease the to-hit modifier by 1;
	end if;
	if the global defender is calm begin;
		say " - 1 (opponent calm)[run paragraph on]";
		decrease the to-hit modifier by 1;
	end if;
	if the global defender is frantic begin;
		say " + 1 (opponent frantic)[run paragraph on]";
		increase the to-hit modifier by 1;
	end if;
	if the global defender is frenzied begin;
		say " + 2 (opponent frenzied)[run paragraph on]";
		increase the to-hit modifier by 2;
	end if.


To increase the excitement of (the subject - a person):
	change the excitement of the subject to the excitement after the excitement of the subject;
	say " You are now [bold type][excitement of the player][roman type]![run paragraph on]";
	if the excitement of the subject is lost begin;
		if the subject is the player begin;
			end the game saying "You suffer a heart attack!";
		otherwise;
			say "[The subject] becomes too excited, and suffers a fatal heart attack!";
			deal 10000 damage to the subject;
		end if;
	end if.

To decrease the excitement of (the subject - a person):
	change the excitement of the subject to the excitement before the excitement of the subject;
	if the excitement of the subject is lost, now the excitement of the subject is serene;
	if the excitement of the subject is the excitement before the base excitement state of the subject, now the excitement of the subject is the base excitement state of the subject.


Calming down is an action applying to nothing. Understand "calm" and "calm down" as calming down.

Check calming down:
	if a hostile alive monster is enclosed by the location, say "You cannot calm down while engaged in a fight." instead;
	if the excitement of the player is the base excitement state of the player, say "You are already as calm as you will get." instead.

Carry out calming down:
	now the excitement of the player is the base excitement state of the player;
	say "You take a couple of deep breaths until you are [excitement of the player] again.".


Section 1.1.0.1.9 - Sublocations

A person has a number called the sublocation. The sublocation of a person is usually 0.

A room has a table-name called the Sublocations.

The Sublocations of a room is usually the Table of Standard Sublocations.

[The Tables of Sublocations are governed by the following rules.

Each line tells us whether people in the first location can attack those in the second location.

"Potential" take the following standard values:
0 = No
1 = Yes
2 = Only when ranged

Additional values can be defined by the author, for instance, to make sure that people standing on higher ground have an advantage over those standing on lower ground. Setting the sublocations of actors (as they move around within a location or between locations) is left to the author.]

Table of Standard Sublocations
First location	  Second location	     Potential			Message
0				0				1				some text


To decide whether (the attacker - a person) can reach (the defender - a person):
	repeat through the Sublocations of the location begin;
		if the First Location entry is the sublocation of the attacker begin;
			if the Second Location entry is the sublocation of the defender begin;
				if the potential entry is 0 begin;
					say the Message entry;
					decide no;
				end if;
				if the potential entry is 1, decide yes;
				if the potential entry is 2 begin;
					if the attacker is ranged, decide yes;
					say the Message entry;
					decide no;
				end if;
			end if;
		end if;
	end repeat;
	decide yes.

[The rule that triggers this stuff.]

A whether attacking begins rule (this is the check sublocation accessibility rule):
	unless the global attacker can reach the global defender, stop.

[Some more standard tables of sublocations.]

[This table is for a room with two sublocations which can only reach each other through ranged attacks.]

Table of Simple Range Separation Sublocations
First location	  Second location	     Potential		Message
0				0				1			--
0				1				2			"[if the global attacker is not the player][The global attacker] doesn't[otherwise]You don't[end if] have a ranged weapon.[paragraph break]"
1				0				2			"[if the global attacker is not the player][The global attacker] doesn't[otherwise]You don't[end if] have a ranged weapon.[paragraph break]"
1				1				1			--


[This table is for a room with two sublocations from which you cannot reach each other]

Table of Two Divided Sublocations
First location	  Second location	     Potential		Message
0				0				1		some text
0				1				0		"[The global attacker] cannot reach [if the global defender is not the player][the global defender][otherwise]you[end if].[paragraph break]"
1				0				0	       "[The global attacker] cannot reach [if the global defender is not the player][the global defender][otherwise]you[end if].[paragraph break]"
1				1				1	       --

[This table is for a room with two sublocations where you can reach sublocation 1 from sublocation 0, but not the other way around.]

Table of Simple Asymmetric Sublocations
First location	  Second location	     Potential			Message
0				0				1				some text
0				1				1				--
1				0				0				 "[The global attacker] cannot reach [if the global defender is not the player][the global defender][otherwise]you[end if].[paragraph break]"
1				1				1				--


Section 1.1.0.1.10 - Ranged attack

[Very preliminary implementation. All I'm going to do is give everyone an attribute that says whether their attack is ranged or not.]

A person is either ranged or not-ranged. A person is usually not ranged.


Section 1.1.0.1.11 - Storing actions

[Okay, so the idea is this. Everyone declares an action. These actions are stored in a table, and then carried out in some order, which need not be the order in which they have been declared.]

The combat running variable is a truth state that varies. The combat running variable is false.

Table of Stored Combat Actions
Combat Speed		Combat Action
a number				a stored action
with 50 blank rows

To run the combat:
	now the combat running variable is true;
	sort the Table of Stored Combat Actions in Combat Speed order;
	repeat through the Table of Stored Combat Actions:
		try the Combat Action entry;
		blank out the whole row;
	now the combat running variable is false.

Last every turn:
	run the combat.





Part 1.1.1 - Modeling the Fight


Section 1.1.1.0.1 - Starting combat

The noattack boolean is a truth state that varies.

The favour boolean is a truth state that varies.

First every turn when a hostile alive monster is enclosed by the location:
	if the combat boolean is 0, start a combat.

To start a combat:
	calculate the initial combat significance;
	now the noattack boolean is true;
	now the combat boolean is 1;
	if the favour boolean is false, randomly assign favour;
	now the favour boolean is true. [set back to false after winning a fight]



Chapter 1.1.1.1 - Calculating an attack 


Attack type is a kind of value. The attack types are normal, silent, free and fiery. 

The attack state is an attack type that varies. The attack state is usually normal.





Section 1.1.1.1.1 - Define monster


A monster is a kind of person. 



Section 1.1.1.1.2 - Striking a blow

The to-hit roll is a number that varies. The to-hit modifier is a number that varies. The damage is a number that varies. The damage modifier is a number that varies. The final damage is a number that varies.

The global defender is a person that varies. The global attacker is a person that varies.

The global flavour text boolean is a truth state that varies. The global flavour text boolean is usually false.

The reset combat variables is a rulebook.
The whether attacking begins is a rulebook.
The preliminary results of attacking is a rulebook.
The basic attack roll is a rulebook.
The whether attack modifiers apply is a rulebook.
The attack modifiers is a rulebook.
The always-present attack modifiers is a rulebook.
The show results of the attack roll is a rulebook.
The whether the attack hit is a rulebook.
The immediate results of hitting is a rulebook.
The basic damage roll is a rulebook.
The damage modifiers is a rulebook.
The always-present damage modifiers is a rulebook.

To make (attacker - a person) strike a blow against (defender - a person):
	now the global attacker is the attacker;
	now the global defender is the defender;
	consider the reset combat variables rules;
	abide by the whether attacking begins rules; [Stage 1: Whether attacking begins]
	consider the preliminary results of attacking rules; [Stage 2: Preliminary results of attacking]
	consider the basic attack roll rules; [Stage 3: Basic attack roll]
	consider the whether attack modifiers apply rules; [Stage 4: Do attack modifiers apply?]
	if rule succeeded, consider the attack modifiers rules;[Stage 5: Apply attack modifiers]
	consider the always-present attack modifiers rules; [Stage 6: Apply attack modifiers that always apply]
	consider the show results of the attack roll rules;
	consider the whether the attack hit rules;
	if rule succeeded begin;
		consider the immediate results of hitting rules;
		consider the basic damage roll rules;
		consider the damage modifiers rules;
		consider the always-present damage modifiers rules;
		say "[bold type] damage[italic type], ]";
		if the damage is greater than 0, calculate the final damage the attacker does against the defender;
		if the final damage is greater than 0, now the deadly combat boolean is false; 
		if the final damage is 0 begin;
			if the defender is not the player, say "allowing [the defender] to escape unscathed.[run paragraph on]";
			if the defender is the player, say "allowing you to escape unscathed.[run paragraph on]";
		end if;
		if final damage is greater than 0 begin;
			if final damage is less than the blood of the defender begin;
				decrease the blood of the defender by the final damage;
				if the defender is not the player, say "wounding [the defender] to ", blood of the defender, " blood.[run paragraph on]" ;
				if the defender is the player, say "wounding you to ", blood of the defender, " blood.[run paragraph on]";
				let the defender lose concentration;
[				if the attacker is the player and the defender is not non-exciting and a random chance of 1 in 20 succeeds, increase the excitement of the player;]
[				if the defender is the player and the attacker is not non-exciting and a random chance of 1 in 15 succeeds, increase the excitement of the player;]
			otherwise;
				decrease the blood of the defender by the final damage;
				if the defender is not the player begin;
					say "killing [the defender].[run paragraph on]";
					receive blood for the defender;
					if the defender is not non-exciting and a random chance of 2 in 3 succeeds, increase the excitement of the player;
					[if a random chance of 1 in 3 succeeds and the defender is not non-exciting, increase the excitement of the player;]
					now the cleave melee bonus is the to-hit roll minus the defence of the defender;
					now the cleave damage bonus is 0 minus the blood of the defender;
				end if;
				if the defender is the player begin;
					say "killing you.";
					end the game saying "You have been slain.";
				end if;
			end if;
		end if;
	end if;
	take away all until attacking bonuses; [We now take away the until attacking bonuses.]
	say "[roman type]";
	if the attacker is the player or the defender is the player begin; [We only print flavour text when it's not monster vs monster, because writing appropriate texts for all monster vs monster interactions is a quadratic rather than a linear task.]
		say "[paragraph break]"; [Here we start printing the flavour text.]
		now the global flavour text boolean is true; [To ensure that (killed) is not printed.]
		if the attacker is the player begin;
			choose a random row from the Player Flavour Texts of the defender;
		otherwise;
			if the defender is the player, choose a random row from the Monster Flavour Texts of the attacker;
		end if;
		if the defender is killed begin;
			if the defender is not boss, say "[Fatal Text entry]";
		otherwise;
			if the to-hit roll is not greater than the defence of the defender, say "[Miss Text entry]";
			if the to-hit roll is greater than the defence of the defender begin;
				if the final damage is greater than 0, say "[Hit Text entry]";
				if the final damage is 0, say "[Absorbed Text entry]";
			end if;
		end if;
	end if; 
	now the global flavour text boolean is false;
	if the player is not killed, determine aftereffects for the attacker and defender;
	if the defender is not killed or the defender is not boss, say "[paragraph break]".


A reset combat variables rule (this is the standard reset combat variables rule):
	now the damage is 0; 
	now the final damage is 0;
	now the to-hit roll is 0;
	now the to-hit modifier is 0;
	now the damage modifier is 0.

A basic attack roll rule (this is the standard attack roll rule):
	say "[italic type]Rolling ";
	change the to-hit roll to a random number between 1 and 10;
	say the to-hit roll, "[run paragraph on]".

A show results of the attack roll rule (this is the standard result of the attack roll rule):
	increase the to-hit roll by the to-hit modifier;
	say " = ", the to-hit roll, ", [run paragraph on]";

A whether the attack hit rule (this is the standard whether the attack hit rule):
	if the to-hit roll is greater than the defence of the global defender begin;
		if the global attacker is the player, say "you beat "; otherwise say "[the global attacker] beats ";
		say "[possessive of global defender] defence rating of ", the defence of the global defender, ".";
		rule succeeds;
	otherwise;
		if the global attacker is the player, say "you do ";
		if the global attacker is not the player, say "[the global attacker] does ";
		say "not overcome [possessive of global defender] defence rating of ", the defence of the global defender, ".[run paragraph on]";
		rule fails;
	end if.

First basic damage roll rule (this is the standard damage roll rule):
	change the damage to a random number between 1 and the damage die of the global attacker.

Last basic damage roll rule (this is the display damage roll rule):
	if the global attacker is the player, say "You deal [bold type]", damage, "[italic type]";
	if the global attacker is not the player, say "[The global attacker] deals [bold type]", damage, "[italic type]"; 

Section - Printing the results of a blow




Section 1.1.1.1.3 - Calculating the to-hit modifier

A whether attack modifiers apply rule (this is the attack modifiers apply unless something intervenes rule):
	rule succeeds.


An attack modifiers rule (this is the standard attack bonus rule):
		say " + ", the melee of the global attacker, "[run paragraph on]";
		increase the to-hit modifier by the melee of the global attacker.




Section 1.1.1.1.4 - Calculating the damage

First damage modifiers rule (this is the temp rule):
	if the cleave boolean is false begin; [No extra attack bonus when cleaving]
		if the attack state is not fiery begin; [Things that do not work with touch attacks]
			say ""; [Currently useless! Have to think about it.]
		end if;
		if the damage bonus of the global attacker is not 0 begin;
			increase the damage modifier by the damage bonus of the global attacker;
			say " + ", damage bonus of the global attacker, " (inherent damage bonus)";
		end if;
		if the deadly combat bonus is not 0 begin;
			increase the damage modifier by the deadly combat bonus;
			if the deadlier combat boolean is true, increase the damage modifier by the deadly combat bonus;
			if the deadlier combat boolean is false, say " + ", deadly combat bonus, " (deadly combat)";
			if the deadlier combat boolean is true, say " + ", 2 times the deadly combat bonus, " (deadlier combat)";
		end if;
		if the beat is not 0 and the beat count is 0 and the beat strength is not 0 begin;
			increase the damage modifier by the beat strength;
			say " + ", beat strength, " (beat)";
		end if;
		calculate the excitement damage bonus of the global attacker;
		if the concentration of the global attacker is greater than 1 begin;
			if the concentration of the global attacker is 2, now the first dummy is 2;
			if the concentration of the global attacker is 3, now the first dummy is 4;
			if the global attacker is at parry, increase the first dummy by 1; [another +1 bonus]
			say " + ", the first dummy, " (concentration)";
			increase the damage modifier by the first dummy;
		end if;
		if the sacrificial number of the global attacker is greater than 0 begin;
			say " + ", the sacrificial number of the global attacker, " (sacrifice)";
			increase the damage modifier by the sacrificial number of the global attacker;
			now the sacrificial number of the global attacker is 0;
		end if;
		if the damage await bonus is greater than 0 and the global attacker is the player begin;
				say " + ", the damage await bonus, " (awaiting)";
				increase the damage modifier by the damage await bonus;
		end if;
		if the global attacker is smashing, do smashing blow with global attacker and global defender;  [Smashing blow]
	end if;
	if the cleave boolean is true begin;
		if the cleave damage bonus is greater than 0, say " + ", the cleave damage bonus, " (cleave)";
		increase the damage modifier by the cleave damage bonus;
	end if;
	if the global defender is at parry begin; [parrying]
		if the global defender is not shielded, now the first dummy is a random number between 0 and 4;
		if the global defender is shielded, now the first dummy is a random number between 2 and 6;
		if the first dummy is not 0, say " - ", first dummy, " (opponent parrying)";
		decrease the damage modifier by the first dummy;
	end if;
	if the damage reduction of the global defender is not 0 begin;
		say " - ", the damage reduction of the global defender, " (inherent damage reduction)";
		decrease the damage modifier by the damage reduction of the global defender;
	end if;
	increase the damage by the damage modifier;
	say " = [bold type]", damage, "[italic type]";
	continue the activity.

Section 1.1.1.1.5 - Calculating the final damage

To calculate the final damage (attacker - a person) does against (defender - a person):
    now the final damage is the damage;
    if the elda armour status of the defender is greater than 0, do elda armour with attacker and defender;
    continue the activity.

Section 1.1.1.1.6 - Receiving blood after a kill

To receive blood for (the victim - a person):
	now the third dummy is the permanent blood of the player - the blood of the player;
	now the fourth dummy is the gained blood of the victim;
	if the fourth dummy is greater than the third dummy, now the fourth dummy is the third dummy;
	if the fourth dummy is greater than 0 begin;
		say " [bold type](Your blood increases by ", the fourth dummy;
		increase the Blood of the player by the fourth dummy;
		if the beat is not 0 and the beat count is 0 and the beat strength is not 0 and the blood of the player is not the permanent blood of the player begin;
			now the fourth dummy is the beat strength;
			now the third dummy is the permanent blood of the player - the blood of the player;
			if the fourth dummy is greater than the third dummy, now the fourth dummy is the third dummy;
			increase the blood of the player by the fourth dummy;
			if the fourth dummy is greater than 0, say " + ", fourth dummy, " extra beat bonus";
		end if;
		say ".)[roman type][run paragraph on]";
	end if.
	


Section 1.1.1.1.7 - Deal x damage to y

To deal (x - a number) damage to (the sucker - a person):
	decrease the blood of the sucker by x;
	  if the blood of the sucker is greater than 0 begin;
		let the sucker lose concentration between brackets;
		continue the activity;
	  end if;
          if the sucker is not the player begin;
		say "(killing [the sucker])[run paragraph on]";
		receive blood for the sucker;
		say "[paragraph break]";
		stop the action;
	  end if;
          if the sucker is the player begin;
              say "(killing you!)";
              end the game saying "You have been slain.";
          end if.


To deal (x - a number) damage to (the sucker - a person) with alternative layout:
	decrease the blood of the sucker by x;
	  if the blood of the sucker is greater than 0 begin;
		say "[paragraph break]";
		let the sucker lose concentration between brackets;
		continue the activity;
	  end if;
          if the sucker is not the player begin;
		say " This kills [the sucker]![run paragraph on]";
		receive blood for the sucker;
		say "[paragraph break]";
		stop the action;
	  end if;
          if the sucker is the player begin;
              say " This kills you!";
              end the game saying "You have been slain.";
          end if.



Section 1.1.1.1.8 - Aftereffects

To determine aftereffects for (the attacker - a person) and (the defender - a person):
	if the attack state is not free, now the concentration of the attacker is 0;
	if the attacker is vampiric, do sucking blood with the attacker and the defender;
	if the attack state is fiery begin;
		if the final damage is greater than 0 begin;
			if a random chance of 1 in 3 succeeds begin;
				if the attacker is the player, say " Unfortunately, [bold type][the defender] does not catch fire[roman type].[run paragraph on]";
				if the attacker is not the player, say  "Fortunately, [bold type]you do not catch fire[roman type]![run paragraph on]";
			otherwise;
				if the attacker is the player, say " In addition, [bold type][the defender] catches fire[roman type]![run paragraph on]";
				if the attacker is not the player, say " [The attacker] [bold type]sets you aflame[roman type]![run paragraph on]";
				set fire to the defender;
			end if;
		end if;
	end if;
	if the attacker is poisonous begin;
		if the final damage is greater than 0 begin;
			if the defender is the player, have the attacker poison the defender;
		end if;
	end if;
	if the attacker is onholder begin;
		if the final damage is greater than 0 begin;
			if the defender is the player, have the attacker hold on to the defender;
		end if;
	end if;
	if the defender is an alive onholder begin;
		if the final damage is not less than the hold release of the defender begin;
			if the hold location of the defender is not 0, say " Stunned by the blow, [bold type][the defender] releases you[roman type]![run paragraph on]";
			now the hold location of the defender is 0;
		end if;
	end if;
	if the attacker is on fire begin;
		if a random chance of 1 in 4 succeeds begin;
			now the printing state is printing-fiery;
			say " [bold type]Flames[roman type] leap from [the attacker] to [the defender]![run paragraph on]";
			now the printing state is printing-normal;
			set fire to the defender;
		end if;
	end if;
	if the defender is on fire begin;
		if a random chance of 1 in 8 succeeds begin;
			now the printing state is printing-fiery;
			say " [bold type]Flames[roman type] leap from [the defender] to [the attacker]![run paragraph on]";
			now the printing state is printing-normal;
			set fire to the attacker;
		end if;
	end if;
	if an on fire monster is enclosed by the location begin;
		if the defender is not on fire begin;
			if the attacker is the player begin;
				now the monster dummy is a random on fire monster enclosed by the location;
				if a random chance of 1 in 6 succeeds begin;
					now the printing state is printing-fiery;
					say " Your furious attack pushes [the defender] towards [the monster dummy]. [bold type]Flames[roman type] leap from the latter to the former![run paragraph on]";
					now the printing state is printing-normal;
					set fire to the defender; 
				end if;
			end if;
		end if;
	end if;
	now the attack state is normal;
	if the defender is killed and the cleave boolean is false and an alive hostile monster is enclosed by the location begin; [Right now, you cannot cleave more than once.]
		now the cleave boolean is true;
		now the monster dummy is a random alive hostile monster enclosed by the location;
		say "[paragraph break]You get a free [bold type]cleave[roman type] attack! ";
		choose a row with skill of Greater Cleave from the Table of Player Skills;
		if the have entry is 0 begin;
			now the cleave melee bonus is the cleave melee bonus divided by 2;
			now the cleave damage bonus is the cleave damage bonus divided by 2;
		end if;
		make the player strike a blow against the monster dummy;
		now the cleave boolean is false;
	end if.


Section 1.1.1.1.9 - Lose concentration

To let (the defender - a person) lose concentration:
	if the concentration of the defender is 0, continue the activity;
	if the defender is determined begin;
		now the first dummy is a random number between 1 and 6;
		if the first dummy is not less than the final damage begin;
			say " Because you are so [bold type]determined[roman type], you do not lose your concentration![run paragraph on]";
			continue the activity;
		end if;
	end if;
	now the concentration of the defender is 0;
	if the defender is the player, say " You lose your [bold type]concentration[roman type]![run paragraph on]";
	if the defender is not the player, say " [The defender] loses [bold type]concentration[roman type]![run paragraph on]".

To let (the defender - a person) lose concentration between brackets:
	if the concentration of the defender is 0, continue the activity;
	if the defender is determined begin;
		now the first dummy is a random number between 1 and 6;
		if the first dummy is not less than the final damage begin;
			say " (not making you lose your concentration, since you are so [bold type]determined[roman type])[run paragraph on]";
			continue the activity;
		end if;
	end if;
	now the concentration of the defender is 0;
	if the defender is the player, say "(making you lose your [bold type]concentration[roman type])[run paragraph on]";
	if the defender is not the player, say "(making [the defender] lose [bold type]concentration[roman type])[run paragraph on]".


Section 1.1.1.10 - Taking away until attacking bonuses

To take away all until attacking bonuses:
	now the global attacker is not at parry;
	now the global attacker is not at dodge;
	if the global attacker is the player, now the scouting boolean is false;
	if the global attacker is the player, cancel all scheduled giving the await bonus;
	







Chapter 1.1.1.2 - Standard Combat Actions


Section 1.1.1.2.1 - Attacking

The block attacking rule is not listed in any rulebook.

Understand "a [thing]" as attacking.

Does the player mean attacking a killed monster: it is unlikely.
Does the player mean attacking a hostile alive monster: it is very likely.

A check attacking rule: if the noun is not a person, say "Things are not your enemies." instead.

A check attacking rule: if the noun is not alive, say "[The noun] is already dead." instead.

A check attacking rule: if the noun is not a monster, say "Save your energy for monsters." instead.


Carry out an actor attacking when the combat running variable is false:
	say "[The actor] prepares to attack [the noun].";
	choose a blank row in the Table of Stored Combat Actions;
	now the Combat Speed entry is 5;
	now the Combat Action entry is the action of the actor attacking the noun.
   
Carry out an actor attacking when the combat running variable is true:
	make the actor strike a blow against the noun.



Section 1.1.1.2.2 - Parrying and Dodging
     

Parrying is an action applying to nothing. Understand "parry" and "p" as parrying.

A person can be at parry or not at parry. A person is usually not at parry.

Carry out parrying:
	now the actor is at parry;
	now the actor is not at dodge;
	say "You strike up a defensive pose.".




Dodging is an action applying to nothing. Understand "dodge" and "do" as dodging.

A person can be at dodge or not at dodge. A person is usually not at dodge.

Carry out dodging:
	now the actor is at dodge;
	now the actor is not at parry;
	say "You ready yourself for quick evasive maneuvers."

An always-present attack modifiers rule (this is the dodging defence bonus rule):
	if the global defender is at dodge begin;
		say " - 2 (defender dodging)[run paragraph on]";
		decrease the to-hit modifier by 2;
	end if.

An attack modifiers rule (this is the dodging attack bonus rule):
	if the global attacker is at dodge begin;
		say " + 1 (dodge bonus)[run paragraph on]";
		increase the to-hit modifier by 1;
	end if.



Section 1.1.1.2.3 - Retreating

Speed is a kind of value. The speeds are medium speed, fast and slow. A person has a speed. A person is usually medium speed.

The retreat location is room that varies. The retreat roll is a number that varies. The retreat monster is a person that varies. The retreat troolean is a number that varies. [0: no special messages; 1: surrounded; 2: specific monster.] The retreat troolean is 0.

Carry out going (this is the set the retreat location rule): now the retreat location is the location.
The set the retreat location rule is listed first in the carry out going rulebook.

Check going: 
	if a hostile alive monster is enclosed by the location begin; 
		say "You can't just [italic type]go[roman type] in the middle of a fight; all you can attempt to do is [italic type]retreat[roman type]."; 
		take no time;
		stop the action;
	end if;

Retreating is an action applying to nothing. Understand "retreat" and "r" as retreating.

Check retreating:
	if no hostile alive monster is enclosed by the location, say "You start shrieking and running--only to notice a few moments later that no enemies are around." instead;
	if a hostile alive onholder monster is enclosed by the location begin;
		repeat with the brute running through hostile alive onholder monsters enclosed by the location begin;
			if the hold location of the brute is not 0, say "You cannot retreat while [the brute] holds on to you!" instead;
		end repeat;
	end if;
	now the first dummy is 0; now the second dummy is 0; now the third dummy is 0; now the fourth dummy is 0; now the monster dummy is a random hostile monster enclosed by the location; [We will use the first dummy to calculate the retreat score of the current monster; the second dummy to calculate the final retreat score; the third dummy to calculate the number of monsters with retreat score higher than 0; the fourth dummy to store the highest retreat score; and the monster dummy to store a monster with the highest retreat score.]
	repeat with the opponent running through hostile alive monsters enclosed by the location begin;
		now the first dummy is 0;
		increase the first dummy by 1;
		if the opponent is fast, increase the first dummy by 1;
		if the opponent is slow, decrease the first dummy by 1;
		if the blood of the opponent is greater than the blood of the player, now the first dummy is the first dummy times 2;
		increase the second dummy by the first dummy;
		if the first dummy is greater than 0, increase the third dummy by 1;
		if the first dummy is greater than the fourth dummy begin;
			now the fourth dummy is the first dummy;
			now the monster dummy is the opponent;
		otherwise;
			if the first dummy is the fourth dummy begin;
				if a random chance of 1 in 2 succeeds, now the monster dummy is the opponent;
			end if;
		end if; 
	end repeat;
	change the retreat roll to a random number between 1 and 6;
	say "(Rolling ", retreat roll;
	if the scouting boolean is true begin;
		increase the retreat roll by 4;
		say " + 4 (scouting) = ", retreat roll;
	end if;
	say " against a target number of ", second dummy + 1, "... ";
	if the retreat roll is not greater than the second dummy begin;
		say "failure! ";
		decrease the third dummy by 1; [You cannot be surrounded by 1 monster.]
		now the first dummy is the third dummy + the fourth dummy; [first and second dummy have done their duties and are now again used as simple dummies]
		now the second dummy is a random number between 1 and the first dummy;
		if the second dummy is greater than the fourth dummy begin;
			say " Your enemies have surrounded you.)";
			now the retreat troolean is 1;
		otherwise;
			say " Quickly blocking your way, [the monster dummy] prevents your escape.)";
			now the retreat troolean is 2;
			now the retreat monster is the monster dummy;
		end if; 
		stop the action;
	otherwise;
		say "success!)";
		now the scouting boolean is false;
	end if.

Carry out retreating:
	if the retreat troolean is 0, say "You run away.";
	if the retreat troolean is 1, say "Breaking through the line of your enemies, you dash for safety.";
        if the retreat troolean is 2, say "Dashing past the [retreat monster], you flee the battlefield.";
	move the player to the retreat location;
	now the combat boolean is 0;
	now the retreat troolean is 0;
	now the concentration of the player is 0.



Section 1.1.1.2.4 - Concentrating

Concentrating is an action applying to nothing. Understand "concentrate" and "c" as concentrating.

Carry out concentrating:
	increase the concentration of the actor by 1;
	if the concentration of the actor is greater than 3, now the concentration of the actor is 3;
	if the actor is not the player, say "[The actor] concentrates.";
	if the actor is the player begin;
		if the concentration of the player is 1, say "You are now mildly concentrated.";
		if the concentration of the player is 2, say "You are now quite concentrated.";
		if the concentration of the player is 3, say "You are now maximally concentrated.";
	end if;
	if the concentration of the actor is 1 and a random chance of 1 in 4 succeeds, decrease the excitement of the actor;
	if the concentration of the actor is 2 and a random chance of 1 in 3 succeeds, decrease the excitement of the actor;
	if the concentration of the actor is 3 and a random chance of 1 in 2 succeeds, decrease the excitement of the actor.



Section 1.1.1.2.5 - Saving

Check saving the game:
	decrease the zeal of the player by the level of the player;
	if the zeal of player is less than 0, now the zeal of the player is zero.



Section 1.1.1.2.6 - Undo
[
Rule for deciding whether to allow undo:
		if the combat boolean is 1 begin;
			say "You cannot undo during fights.";
			deny undo;
		end if.
]

Section 1.1.1.2.7 - Cleave

[Cleaving is an automatic bonus attack which you get if you kill an enemy with a non-cleave.]

[The attack bonus of this attack is 50% of the difference between your original augmented melee roll and the defence of your original victim. The damage bonus of this attack is 50% of the difference between the damage you did and the damage you had to do to kill your original victim. These percentages are boosted to 100% if the player has improved cleave and the necessary zeal.]

The cleave boolean is a truth state that varies. The cleave boolean is usually false. [This determines whether we are cleaving.]

The cleave melee bonus is a number that varies.

The cleave damage bonus is a number that varies.

First whether attack modifiers apply rule (this is the no attack modifiers when cleaving rule):
	if the cleave boolean is true, rule fails.

First always-present attack modifiers rule (this is the cleave to-hit bonus rule):
	if the cleave boolean is true begin;
		if the cleave melee bonus is greater than 0, say " + ", the cleave melee bonus, " (cleave)[run paragraph on]";
		increase the to-hit modifier by the cleave melee bonus;
	end if.

Chapter 1.1.1.3 - Artifical Intelligence

Section 1.1.1.3.1 - Making sure the monsters attack

The monster attack boolean is a truth state that varies.

Every turn when a not summoned hostile alive monster is enclosed by the location:
	if the noattack boolean is true begin;
		now the noattack boolean is false;
	otherwise;
		repeat with the opponent running through not summoned hostile alive monsters enclosed by the location begin;
       			if the player is killed, stop;
			now the monster attack boolean is true;
			if the opponent is an onholder begin; [Holding on]
				if the hold location of the opponent is greater than 0 begin;
					now the monster attack boolean is false;
					have the opponent deal hold damage to the player;
				end if;
			end if;
			if the opponent is an erratic attacker begin; [Erratic attacker]
				now the first dummy is a random number between 1 and 6;
				if the first dummy is greater than the erratic attack odds of the opponent begin;
					now the global attacker is the opponent; [to make the messages come out good]
					say the erratic attack failure text of the opponent;
					now the monster attack boolean is false;
				end if;
			end if;
			now the monster dummy is the player;
			repeat with the victim running through summoned hostile alive monsters enclosed by the location begin;
				if a random chance of 1 in 8 succeeds, now the monster dummy is the victim;
			end repeat;
			if the  monster attack boolean is true, try the opponent attacking the monster dummy;
		end repeat;
	end if.

Every turn when a summoned alive monster is enclosed by the location:
	if the noattack boolean is true begin;
		now the noattack boolean is false;
	otherwise;
		repeat with the opponent running through summoned alive monsters enclosed by the location begin;
       			if the player is killed, stop;
			now the monster dummy is the player;
			if an alive not summoned monster is enclosed by the location begin;
				now the first dummy is a random number between 1 and 5;
				if the first dummy is not 1 begin;
					now the monster dummy is a random alive not summoned monster enclosed by the location;
				end if;
			end if;
			make the opponent strike a blow against the monster dummy;
		end repeat;
	end if.




Section 1.1.1.4.0 - Triggering the rules

Last every turn when no hostile alive monster is enclosed by the location and no indifferent monster is enclosed by the location:
	if the combat boolean is 1, grant zeal;
	now the combat boolean is 0;
	take away all end-of-combat bonuses.


Last every turn when no hostile alive monster is enclosed by the location:
	if a random chance of 1 in 4 succeeds, decrease the excitement of the player.


After going:
	take away all until-moving bonuses;
	continue the activity.



Section 1.1.1.4.1 - Taking away all the until end of combat bonuses

To take away all end-of-combat bonuses:
	if the player is angry begin; 
		now the player is not angry;
		decrease the excitement of the player;
		say "Your anger subsides.";
	end if; [Anger]
	now the deadlier combat boolean is false; [Deadlier Combat]
	now the sacrificial number of the player is 0; [Sacrifice]
	cancel all scheduled giving the await bonus; [Await]
	now the await bonus is 0; now the potential await bonus is 0;
	cancel all scheduled taking away the await bonus.


		

Section 1.1.1.4.2 - Taking away all the until moving bonuses

To take away all until-moving bonuses:
	now the concentration of the player is 0;
	now the player is not at dodge;
	now the player is not at parry;
	now the elda armour status of the player is 0; [Bronze/Iron/Steel Armour]
	now the player is not shielded; [Shield]
	now the player is not determined; [Determination]








Book 1.3 - Zeal and Favour

Part 1.3.1 - Idols

An idol is a kind of container. An idol is fixed in place.

An Idol is either favoured, unfavoured or disfavoured. An Idol is usually unfavoured.

The Groth Idol is an idol. The Elda Idol is an idol. The Duncan Idol is an idol. The Shliss Idol is an idol.



Part 1.3.2 - Zeal

To grant zeal:
	now the favour boolean is false;
	now the third dummy is the zeal of the player;
	if the third dummy is less than the permanent zeal of the player, now the third dummy is the permanent zeal of the player; [Zeal shouldn't become higher than maximum, unless it already is, in which case it should stay the same]	
	if the initial combat significance is greater than 0 begin;
		now the second dummy is 0;
		if the initial combat significance is 1, now the second dummy is 1;
		if the initial combat significance is 2, now the second dummy is 2;
		if the initial combat significance is 3 begin;
			now the second dummy is a random number between 3 and the level of the player;
			if the second dummy is less than 3, now the second dummy is 3;
		end if;
		if the initial combat significance is 4 begin;
			now the second dummy is a random number between 5 and 2 times the level of the player;
			if the second dummy is less than 5, now the second dummy is 5;
		end if;
		say "The Gods collectively reward you with ", second dummy, " [bold type]Zeal[roman type]![run paragraph on]";
		if the zeal of the player is not less than the permanent zeal of the player, say " (But you already were at your maximum.)[run paragraph on]";
		increase the zeal of the player by the second dummy;
		now the first dummy is 1;
	end if;
	say "[paragraph break]";
	now the combat boolean is 0;
	if the zeal of the player is greater than the permanent zeal of the player, now the zeal of the player is the third dummy;
	continue the activity.


Part 1.3.3 - Favour

To randomly assign favour:
	repeat with sucker running through idols begin; 
		now sucker is unfavoured;
		if a random chance of 1 in 4 succeeds, now sucker is favoured;
		if a random chance of 1 in 10 succeeds, now sucker is disfavoured;
	end repeat;
	repeat through the Table of Player Skills begin;
		now the first dummy is 1;
		if the Type Entry is "Groth" and the Groth Idol is favoured, now the first dummy is 0;
		if the Type Entry is "Groth" and the Groth Idol is disfavoured, now the first dummy is 2;
		if the Type Entry is "Elda" and the Elda Idol is favoured, now the first dummy is 0;
		if the Type Entry is "Elda" and the Elda Idol is disfavoured, now the first dummy is 2;
		if the Type Entry is "Duncan" and the Duncan Idol is favoured, now the first dummy is 0;
		if the Type Entry is "Duncan" and the Duncan Idol is disfavoured, now the first dummy is 2;
		if the Type Entry is "Shliss" and the Shliss Idol is favoured, now the first dummy is 0;
		if the Type Entry is "Shliss" and the Shliss Idol is disfavoured, now the first dummy is 2;
		now the CurZeal entry is the first dummy times the ZealCost entry;
	end repeat

To say favoured idols:
	now the first dummy is the number of favoured idols;
	if the Groth Idol is favoured begin;
		say "Groth";
		if the first dummy is greater than 1, say ", ";
		decrease the first dummy by 1;
	end if;
	if the Elda Idol is favoured begin;
		say "Elda";
		if the first dummy is greater than 1, say ", ";
		decrease the first dummy by 1;
	end if;
	if the Duncan Idol is favoured begin;
		say "Duncan";
		if the first dummy is greater than 1, say ", ";
		decrease the first dummy by 1;
	end if;
	if the Shliss Idol is favoured begin;
		say "Shliss";
	end if.


To say disfavoured idols:
	now the first dummy is the number of disfavoured idols;
	if the Groth Idol is disfavoured begin;
		say "Groth";
		if the first dummy is greater than 1, say ", ";
		decrease the first dummy by 1;
	end if;
	if the Elda Idol is disfavoured begin;
		say "Elda";
		if the first dummy is greater than 1, say ", ";
		decrease the first dummy by 1;
	end if;
	if the Duncan Idol is disfavoured begin;
		say "Duncan";
		if the first dummy is greater than 1, say ", ";
		decrease the first dummy by 1;
	end if;
	if the Shliss Idol is disfavoured begin;
		say "Shliss";
	end if.











Book 1.2 - Skills

Section - Skills as Value

Skill is a kind of value. The Skills are defined by the Table of Player Skills.

The dummy skill is a skill that varies. The skill boolean is a truth state that varies.

To do the zeal check:
	now the skill boolean is true;
	choose row with a Skill of dummy skill in the Table of Player Skills;
	if the have entry is 0 begin;
		say "You try - fruitlessly, since you do not possess that skill.";
		now the skill boolean is false;
	end if;
	if the zeal of the player is less than the CurZeal entry begin;
		say "You do not have enough Zeal left!";
		now the skill boolean is false;
	end if.

To do the zeal cost:
	choose row with a Skill of dummy skill in the Table of Player Skills;
	decrease the zeal of the player by the CurZeal entry;
	increase the CurZeal entry by the ZealCost entry.

To teach (course - a skill):
	choose row with a Skill of Course in the Table of Player Skills;
	change the have entry to 1;
	say "You learn [skill entry]!".


Part 1.2.1 - The Skills Defined


Chapter 1.2.1.1 - Groth Skills


Section 1.2.1.1.1 - Smashing Blow

A person can be smashing or not smashing. A person is usually not smashing.

Understand the command "smash" as something new.
Smashing is an action applying to one object. Understand "smash [something]" as smashing.

Does the player mean smashing a killed person: it is very unlikely.
Does the player mean smashing a hostile alive monster: it is likely.


Check smashing:
	if the noun is not a person, say "Things are not your enemies." instead;
	if the noun is not alive, say "[The noun] is already dead." instead;
	if the noun is not a monster, say "Save your energy for monsters." instead;
	now the dummy skill is Smashing Blow;
	do the zeal check;
	if the skill boolean is false, stop the action.

Carry out smashing:
	now the dummy skill is Smashing Blow;
	do the zeal cost;
	now the actor is smashing;
	make the actor strike a blow against the noun;
	now the actor is not smashing.

To do smashing blow with (attacker - a person) and (defender - a person):
	change the first dummy to a random number from 1 to 6;
	if the first dummy is 1, now the second dummy is 1;
	if the first dummy is 2, now the second dummy is 2;
	if the first dummy is 3, now the second dummy is 3;
	if the first dummy is 4, now the second dummy is 4;
	if the first dummy is 5, now the second dummy is 6;
	if the first dummy is 6, now the second dummy is 8;
	say " + ", second dummy, " (smashing blow)";
	increase the damage modifier by second dummy;
	continue the activity.


Section 1.2.1.1.2 - Greater Cleave

[No special code needed. This has been taken care of in the Cleave section above. There is no "Greater Cleave" command.]


Section 1.2.1.1.3 - Anger

A person is either angry or not angry. A person is usually not angry.

Becoming angry is an action out of world. Understand "angry" and "anger" as becoming angry.

Check becoming angry:
	if the actor is angry, say "You are angry already." instead;
	now the dummy skill is Anger;
	do the zeal check;
	if the skill boolean is false, stop the action.


Carry out becoming angry:
	now the dummy skill is Anger;
	do the zeal cost;
	say "Rising anger makes you fearsome but reckless.";
	now the player is angry;
	increase the excitement of the player.




Section 1.2.1.1.4 - Deadlier combat

Deadlier combat boolean is a truth state that varies. Deadlier combat boolean is false.

Every turn: if no hostile monster is alive enclosed by the location, now deadlier combat boolean is false.

Starting deadlier combat is an action out of world. Understand "deadlier combat" as starting deadlier combat.

Check starting deadlier combat:
	if deadlier combat boolean is true, say "This combat is already deadlier." instead;
	now the dummy skill is Deadlier Combat;
	do the zeal check;
	if the skill boolean is false, stop the action.


Carry out starting deadlier combat:
	now the dummy skill is Deadlier combat;
	do the zeal cost;
	say "The gods enthusiastically grant your request.";
	now the deadlier combat boolean is true.




  

Chapter 1.2.1.2 - Elda Skills 


Section 1.2.1.2.1 - Bronze Armour

A person has a number called elda armour status. The elda armour status of a person is usually 0.
A person has a number called the elda armour chance. The elda armour chance of a person is usually 0.
A person has a number called elda armour amount. The elda armour amount of a person is usually 0.

Metal is a kind of value. The metals are bronze, iron and steel.

Elda armour metal is a metal that varies.


Making bronze armour is an action applying to nothing. Understand "bronze armour" and "bronze" as making bronze armour.

Check making bronze armour:
	now the dummy skill is Bronze Armour;
	do the zeal check;
	if the skill boolean is false, stop the action.

Carry out making bronze armour:
	now the dummy skill is Bronze Armour;
	do the zeal cost;
	now the elda armour status of the player is 4;
	now the elda armour chance of the player is 4;
	now the elda armour amount of the player is 3;
	now the elda armour metal is bronze;
	say "You feel your skin harden as if it were bronze.".


To do elda armour with (the attacker - a person) and (the defender - a person):
	if the elda armour status of the defender is greater than 0 begin;
		change the first dummy to a random number from 1 to 6;
		increase the first dummy by 1;
		if the first dummy is greater than the elda armour chance of the defender begin;
			now the second dummy is the final damage;
			now the third dummy is the elda armour amount of the defender; [But deadly combat slightly negated. so the following to modifiers apply:]
			if the deadly combat bonus is greater than 2, increase the third dummy by 1;
			if the deadly combat bonus is greater than 4, increase the third dummy by 1;
			if the second dummy is greater than the third dummy, now the second dummy is the third dummy;
			decrease the final damage by the second dummy;
			decrease the elda armour status of the defender by 1;
			if the final damage is 0 begin;
				say "all of which is absorbed by the [elda armour metal] armour";
			end if;
			if the final damage is greater than 0, say second dummy, " of which is absorbed by the [elda armour metal] armour (leaving ", final damage, ")";
			if the elda armour status of the defender is 0, say " (dispelling it)";
			say ", ";
			continue the activity;
		otherwise;
			say "bypassing the [elda armour metal] armour, ";
		end if;
	end if.

An always-present attack modifiers rule (this is the elda armour defence bonus rule):
	if the elda armour status of the global attacker is greater than 0 begin;
		say " - 1 ([elda armour metal] armour)[run paragraph on]";
		decrease the to-hit modifier by 1;
	end if.


To say elda percentage:
	now first dummy is elda armour chance of the player - 1;
	now first dummy is 100 * first dummy;
	now second dummy is first dummy / 6;
	say second dummy.

Section 1.2.1.2.2 - Curse

A person can be cursed or not cursed. A person is usually not cursed.

Cursing is an action applying to one thing. Understand "curse [person]" as cursing.

Does the player mean cursing a killed person: it is very unlikely.

Check cursing:
	now the dummy skill is Curse;
	do the zeal check;
	if the skill boolean is false, stop the action.
	
Carry out cursing:
	now the dummy skill is Curse;
	do the zeal cost;
	say "You [one of]raise your hands and trace intricate patterns in the air[or]point your finger at [the noun] and mutter a few arcane words[or]fix [the noun] with your cold stare and say a single Word of Power[or]shriek horribly at the top of your lungs, holding your sword straight up[at random].";
	now the noun is cursed.
	
	
An attack modifiers rule (this is the cursed attack penalty rule):
	if the global attacker is cursed, say " -  4 (cursed)[run paragraph on]";
	decrease the to-hit modifier by 4.
	
An immediate results of hitting rule (this is the hitting removes curse rule):
	if the global attacker is cursed, say "This breaks the [bold type]curse[roman type]!";
	now the global attacker is not cursed.


Section 1.2.1.2.3 - Shield

A person can be shielded or not shielded. A person is usually not shielded.

Shielding is an action applying to nothing. Understand "shield" as shielding.

Check shielding:
	now the dummy skill is Shield;
	do the zeal check;
	if the skill boolean is false, stop the action.

Carry out shielding:
	now the dummy skill is Shield;
	do the zeal cost;
	now the actor is shielded;
	say "The magic will shield you, improving the [italic type]parry[roman type] action.".



Section 1.2.1.2.4 - Gaseous Form

A person can be gaseous or not gaseous. A person is usually not gaseous.

Becoming gaseous is an action applying to nothing. Understand "gas" and "gaseous" and "gaseous form" as becoming gaseous.

Check becoming gaseous:
	now the dummy skill is Gaseous Form;
	do the zeal check;
	if the skill boolean is false, stop the action.

Carry out becoming gaseous:
	now the dummy skill is Gaseous Form;
	do the zeal cost;
	now the actor is gaseous;
	say "Your body turns insubstantial--for the rest of this turn, you will be immune to attacks!".


Last every turn:
	repeat with current person running through gaseous persons enclosed by the location begin;
		now the current person is not gaseous;
	end repeat.

A whether attacking begins rule (this is the cannot be attacked when gaseous rule):
	if the global defender is gaseous begin;
		if the global defender is the player, say "You are gaseous, so [the global attacker] cannot hit you.";
		if the global defender is not the player, say "[The global defender] is gaseous, so [possessive of the global attacker] attack fails.";
		stop;
	end if.


[Section 1.2.1.2.6 - Iron Armour


Making iron armour is an action applying to nothing. Understand "iron armour" as making iron armour.

Check making iron armour:
	choose row with a Skill of iron Armour in the Table of Player Skills;
	if the have entry is 0, say "You try - fruitlessly, since you do not possess that skill." instead;
	if the zeal of actor is less than the zealcost entry, say "You do not have enough zeal!" instead.

Carry out making iron armour:
	choose row with a Skill of iron Armour in the Table of Player Skills;
	now the elda armour status of the player is 3;
	now the elda armour chance of the player is 5;
	now the elda armour amount of the player is 3;
	now the elda armour metal is iron;
	decrease the zeal of the actor by the zealcost entry;
	say "You feel your skin harden as if it were iron][if a random chance of 1 in 4 succeeds][. 'Real men don't need armour!', Groth growls][end if][.".


Section 1.2.1.2.12 - Steel Armour


Making steel armour is an action applying to nothing. Understand "steel armour" as making steel armour.

Check making steel armour:
	choose row with a Skill of steel Armour in the Table of Player Skills;
	if the have entry is 0, say "You try - fruitlessly, since you do not possess that skill." instead;
	if the zeal of actor is less than the zealcost entry, say "You do not have enough zeal!" instead.

Carry out making steel armour:
	choose row with a Skill of steel Armour in the Table of Player Skills;
	now the elda armour status of the player is 3;
	now the elda armour chance of the player is 5;
	now the elda armour amount of the player is 3;
	now the elda armour metal is steel;
	decrease the zeal of the actor by the zealcost entry;
	say "You feel your skin harden as if it were steel][if a random chance of 1 in 4 succeeds][. 'Real men don't need armour!', Groth growls][end if][".]




Chapter 1.2.1.3 - Duncan Skills

Section 1.2.1.3.1 - Burning Hands

[First, we are going to define burning.]

A person is either on fire or not on fire. A person is usually not on fire.
A person has a number called the burn time.
A person has a number called the minimum burn damage.
A person has a number called the maximum burn damage.

After printing the name of an on fire monster:
	if the printing state is not printing-fiery, say " (burning)".

Every turn:
	repeat with burner running through on fire persons begin;
		if the player is killed, stop the action;
		if the burner is not enclosed by the location, decrease the burn time of the burner by 1;	
		if the burner is enclosed by the location begin;
			if the burner is alive begin;
				now the printing state is printing-fiery;
				now the first dummy is a random number between the minimum burn damage of the burner and the maximum burn damage of the burner;
				if the burner is not the player, say "The flames deal ", first dummy, " damage to [the burner].[run paragraph on]";
				if the burner is the player, say "The flames deal ", first dummy, " damage to you.[run paragraph on]";
				deal first dummy damage to the burner with alternative layout;
				now the printing state is printing-normal;
				decrease the burn time of the burner by 1;
			end if; 
		end if;
		if the burn time of the burner is 0 begin;
			now the burner is not on fire;
			if the burner is not the player, say "The flames around [the burner] die out.[paragraph break]";
			if the burner is the player, say "You are no longer on fire![paragraph break]";
		end if;
		if the burner is killed, now the burner is not on fire;
	end repeat.

[Second, we are going to define the effects of burning. But this is all done in the combat routines.]

[Third, we define the burning hands skills proper]

The block burning rule is not listed in any rulebook.

Does the player mean burning a killed person: it is very unlikely.
Does the player mean burning a hostile alive monster: it is likely.

Check burning:
	now the dummy skill is Burning Hands;
	do the zeal check;
	if the skill boolean is false, stop the action.

Carry out burning:
	if the noun is not an alive monster, say "It is no use trying to set fire to that." instead;
	now the dummy skill is Burning Hands;
	do the zeal cost;
	if the hold location of the noun is not greater than 0 begin;
		say "You approach [the noun], eliciting a free attack against you.[paragraph break]";
		now the first dummy is a random number between 1 and 6;
		if the first dummy is greater than the erratic attack odds of the noun begin;
			now the global attacker is the noun; [to make the messages come out good]
			say the erratic attack failure text of the noun;
		otherwise;	
			now the attack state is free;	
			make the noun strike a blow against the player;
		end if;
	otherwise;
		say "Since [the noun] is holding on to you, you do not have to venture a dangerous approach. ";
	end if;
	now the attack state is fiery;
	make the player strike a blow against the noun.

[Fourth, we define setting fire to someone]

To set fire to (the sucker - a person):
	if the sucker is not fireproof begin;
		now the burn time of the sucker is 5;
		now the minimum burn damage of the sucker is 1;
		now the maximum burn damage of the sucker is 5;
		now the sucker is on fire;
	otherwise;
		say " (But [the sucker] is immune to fire!) ";
	end if.

To silently set fire to (the sucker - a person):
	if the sucker is not fireproof begin;
		now the burn time of the sucker is 5;
		now the minimum burn damage of the sucker is 1;
		now the maximum burn damage of the sucker is 5;
		now the sucker is on fire;
	end if.

An attack modifiers rule (this is the burning hands attack bonus rule):
	if the attack state is fiery begin; [Burning hands]
		say " + 1 (burning hands)[run paragraph on]";
		increase the to-hit modifier by 1;
	end if;

A basic damage roll rule (this is the damage when using burning hands rule):
	if the attack state is fiery, change the damage to a random number between 1 and 3;


Section 1.2.1.3.2 - Summon Imps

Summoning imps is an action applying to nothing. Understand "summon imps" and "summon imp" and "imps" and "imp" as summoning imps.

Check  summoning imps:
	now the dummy skill is Summon Imps;
	do the zeal check;
	if the skill boolean is false, stop the action.

Carry out summoning imps:
	now the dummy skill is Summon Imps;
	do the zeal cost;
	say "You wave your hands, and three imps appear on the battlefield, eager to help your cause! Or so you hope.";
	move the green imp to the location;
	move the red imp to the location;
	move the blue imp to the location;
	now the blood of the green imp is 3;
	now the blood of the red imp is 3;
	now the blood of the blue imp is 4.



Section 1.2.1.3.3 - Scout

Scouting is an action applying to one visible thing. Understand "scout [a direction]" as scouting.

The scouting boolean is a truth state that varies. The scouting boolean is false.

Check scouting:
	now the dummy skill is Scout;
	do the zeal check;
	if the skill boolean is false, stop the action.

Carry out scouting:
	now the dummy skill is Scout;
	do the zeal cost;
	now the scouting boolean is true;
	say "You attempt to scout.";
	try going the noun.




Section 1.2.1.3.4 - Fire Bomb

Firebombing is an action applying to nothing. Understand "bomb" and "fire bomb" and "firebomb" as firebombing.

The fire bomb time is a number that varies.

The bomb is a thing. "Hovering in the air, a small red ball radiates heat onto the battlefield. It is the fire bomb." Instead of taking, pushing or pulling the bomb: say "It is far too hot to touch!". Instead of examining the bomb: say "It appears to be a metal ball, heated until it glows with a faint red glare.". Instead of listening to the bomb: say "The bomb hisses and clicks.". Understand "fire" and "ball" and "red" and "hot" as the bomb.

Check firebombing:
	now the dummy skill is Fire Bomb;
	do the zeal check;
	if the skill boolean is false, stop the action;
	if the bomb is enclosed by the location, say "You cannot have multiple fire bombs at the same time." instead.

Carry out firebombing:
	now the dummy skill is Fire Bomb;
	do the zeal cost;
	say "You throw your hands in the air, and a fire bomb appears in the middle of the battlefield!";
	move the bomb to the location;
	now the fire bomb time is a random number between 1 and 3.

Every turn when the bomb is enclosed by the location:
	if the fire bomb time is 0 begin;
		say "With an enormous [bold type]BANG[roman type] the fire bomb explodes! (";
		now the printing state is printing-fiery;
		repeat with the sucker running through alive not gaseous monsters enclosed by the location begin;
			now the first dummy is a random number between 1 and 6;
			say "Rolling ", first dummy, " against a target number of 5, ";
			if the first dummy is less than 5 begin;
				if the sucker is not fireproof begin;
					say "[the sucker] catches fire. ";
					silently set fire to the sucker;
				otherwise;
					say "[the sucker] would have caught fire if it had not been resistant. ";
				end if;
			otherwise;
				say "[the sucker] does not catch fire. ";
			end if;
		end repeat;
		if the player is not gaseous begin;
			now the first dummy is a random number between 1 and 6;
			say "Anticipating the explosion and rolling ", first dummy, " against a target number of 3, ";
			if the first dummy is less than 3 begin;
				set fire to the player;
				say "you, alas, catch fire!)";
			otherwise;
				say "you duck away at right moment!)";
			end if;
		otherwise;
			say "You are gaseous, and escape the fire.)";
		end if;
		remove the bomb from play;
		now the printing state is printing-normal;
	end if;
	decrease the fire bomb time by 1.





Chapter 1.2.1.4 - Shliss Skills



Section 1.2.1.4.1 - Needle

Needling is an action applying to one thing. Understand "needle [a person]" as needling.

Does the player mean needling a killed person: it is very unlikely.
Does the player mean needling a hostile alive monster: it is likely.

Check needling:
	if the noun is not an alive monster, say "You can only needle live opponents." instead;
	now the dummy skill is Needle;
	do the zeal check;
	if the skill boolean is false, stop the action.

Carry out needling:
	now the dummy skill is Needle;
	do the zeal cost;
	if a random chance of 1 in 6 succeeds, say "Your needle misses." instead;
	say "[one of]Your needle deals 2 damage to [the noun][or]A sharp needle speeds from your hand and hits [the noun] for 2 damage[or]You point a finger at [the noun] and speak a Word of Power. A magical needle shoots from your finger, dealing 2 damage[at random].[run paragraph on]";
	deal 2 damage to the noun with alternative layout. 



Section 1.2.1.4.2 - Determination

Determining is an action applying to nothing. Understand "determination" and "det" as determining.

Determining is acting fast.

A person is either determined or not determined. A person is usually not determined.


Check determining:
	now the dummy skill is Determination;
	do the zeal check;
	if the skill boolean is false, stop the action.

Carry out determining:
	now the dummy skill is Determination;
	do the zeal cost;
	now the player is determined;
	say "You are determined to win this fight!".



Section 1.2.1.4.3 - Sacrifice

Sacrificing is an action applying to one number. Understand "sacrifice [a number]" as sacrificing.

Sacrificing is acting fast.

A person has a number called the sacrificial number. The sacrificial number of a person is usually 0.

Check sacrificing:
	if the number understood is less than 1, say "You have to sacrifice a positive amount of Blood." instead;
	if the number understood is not less than the blood of the player, say "That would kill you!";
	now the dummy skill is Sacrifice;
	do the zeal check;
	if the skill boolean is false, stop the action.

Carry out sacrificing:
	now the dummy skill is Sacrifice;
	do the zeal cost;
	say "You sacrifice ", the number understood, " Blood for a +", the number understood, " damage bonus on your next attack.[run paragraph on]";
	decrease the blood of the player by the number understood;
	now the sacrificial number of the player is the number understood.



Section 1.2.1.4.4 - Await

Awaiting is an action applying to one number. Understand "await [a number]" as awaiting.

The await bonus is a number that varies. The await bonus is 0. The potential await bonus is a number that varies. The potential await bonus is 0. The damage await bonus is a number that varies. The damage await bonus is 0.

Giving the await bonus is an activity. Taking away the await bonus is an activity.

Rule for giving the await bonus:
	say "[bold type](Remember: you now have your await bonus!)[roman type][paragraph break]";
	now the await bonus is the potential await bonus;
	now the potential await bonus is 0.

Rule for taking away the await bonus:
	now the await bonus is 0.

Check awaiting:
	if the number understood is less than 1, say "You must Await a positive number of turns." instead;
	now the dummy skill is Await;
	do the zeal check;
	if the skill boolean is false, stop the action.

Carry out awaiting:
	now the dummy skill is Await;
	do the zeal cost;
	if there is giving the await bonus scheduled begin;
		say "You override your earlier Await command.";
	otherwise;
		say "You await your chance.";
	end if;
	cancel all scheduled giving the await bonus;
	cancel all scheduled taking away the await bonus;
	now the await bonus is 0; now the potential await bonus is 0;
	now the potential await bonus is the number understood;
	now the first dummy is the number understood - 1;
	schedule giving the await bonus in the first dummy turns;
	schedule taking away the await bonus in the number understood turns.

An attack modifiers rule (this is the await attack bonus rule):
	if the global attacker is the player begin; [others should not trigger await]
		if the await bonus is not greater than 0, now the damage await bonus is 0;
		if the await bonus is greater than 0 begin;
			say " + ", the await bonus, " (awaiting)[run paragraph on]";
			increase the to-hit modifier by the await bonus;
			now the damage await bonus is the await bonus;
			now the await bonus is 0;
			now the potential await bonus is 0;
		end if;
	end if;



Part 1.2.2 - Skill Table




Table 3.6 - Player Skills
Skill					Type			Have	OffDefNeu	ZealCost			Lev		CurZeal
Smashing Blow		"Groth"		0			"OFF"		1			1		a number
Greater Cleave		"Groth"		0			"OFF"		1			1
Anger				"Groth"		0			"OFF"		1			1
Deadlier Combat		"Groth"		0			"OFF"		1			1
Groth 5				"Groth"		0			"NEU"		2			2
Gorth 6				"Groth"		0			"OFF"		0			2
Fury					"Groth"		0			"OFF"		2			2
Groth 8				"Groth"		0			"NEU"		3			3
Armour of Blood		"Groth"		0			"DEF"		2			3
Crushing Blow			"Groth"		0			"OFF"		0			3
Groth 11				"Groth"		0			"OFF"		3			4
Rage				"Groth"		0			"OFF"		3			4
Duel					"Groth"		0			"OFF"		5			5
Bronze Armour		"Elda"		0			"DEF"		1			1
Curse				"Elda"		0			"NEU"		1			1
Shield				"Elda"		0			"DEF"		1			1
Gaseous Form			"Elda"		0			"DEF"		1			1
Elda 5				"Elda"		0			"NEU"		2			2
Iron Armour			"Elda"		0			"DEF"		2			2
Improved Curse		"Elda"		0			"NEU"		1			2
Mirror Image			"Elda"		0			"DEF"		3			3
Steel Armour			"Elda"		0			"DEF"		1			3
Elda 10				"Elda"		0			"NEU"		3			3
Mass Curse			"Elda"		0			"NEU"		4			4
Ethereal				"Elda"		0			"DEF"		5			4
Doppelganger			"Elda"		0			"DEF"		5			5
Burning Hands			"Duncan"	0			"OFF"		1			1
Summon Imps			"Duncan"	0			"NEU"		2			1
Scout				"Duncan"	0			"NEU"		1			1
Fire Bomb			"Duncan"	0			"OFF"		2			1
Duncan 5				"Duncan"	0			"NEU"		2			2
Chaos				"Duncan"	0			"NEU"		2			2
Skirmish				"Duncan"	0			"NEU"		2			2
Summon Demons		"Duncan"	0			"NEU"		3			3
Fireball				"Duncan"	0			"OFF"		3			3
Utter Chaos			"Duncan"	0			"NEU"		4			3
Duncan 11			"Duncan"	0			"NEU"		4			4
Summon Horde		"Duncan"	0			"NEU"		5			4
Duncan 13			"Duncan"	0			"NEU"		4			5
Needle				"Shliss"		0			"OFF"		1			1
Determination			"Shliss"		0			"OFF"		2			1
Sacrifice				"Shliss"		0			"NEU"		1			1
Await				"Shliss"		0			"NEU"		2			1
Dominate				"Shliss"		0			"NEU"		2			2
Bleed				"Shliss"		0			"NEU"		2			2
Doom				"Shliss"		0			"OFF"		3			2
Combat Superiority		"Shliss"		0			"NEU"		3			3
Improved Determination	"Shliss"		0			"NEU"		2			3
Shliss 10				"Shliss"		0			"NEU"		0			3
Mass Dominate		"Shliss"		0			"NEU"		4			4
Shliss 12				"Shliss"		0			"NEU"		5			4
Knell					"Shliss"		0			"OFF"		5			5






Part 1.2.3 - The Commands and Learning



Section 1.2.3.0.2 - The Skills command

Bringing up the skills menu is an action out of world. Understand "skills" as bringing up the skills menu.

Carry out bringing up the skills menu:
	change the current menu to the Table of Skills;
	carry out the displaying activity;
	clear the screen;
	try looking.

Section 1.2.3.0.3 - The List Skills command

Listing the skills is an action out of world. Understand "list skill" and "list skills" as listing the skills.

Carry out listing the skills:
	[First, we count the number of skills the player has.]
	now the first dummy is 0; now the second dummy is 0;
	repeat through the Table of Player Skills begin;
		if the have entry is 1, increase the first dummy by 1;
	end repeat;
	if the first dummy is 0 begin;
		say "You still have to learn your first skill."; stop the action;
	end if;
	say "You know the following skills: ";
	repeat through the Table of Player Skills begin;
		if the have entry is 1 begin;
			increase the second dummy by 1;
			say "[skill entry]";
			if the type entry is "Groth", say " (G)";
			if the type entry is "Elda", say " (E)";
			if the type entry is "Duncan", say " (D)";
			if the type entry is "Shliss", say " (S)";
			if the second dummy + 1 is less than the first dummy, say ", ";
			if the second dummy + 1 is the first dummy, say " and ";
			if the second dummy is the first dummy, say ".";
		end if;
	end repeat.

	

Section 1.2.3.0.5 - The Usable Skills command

Listing the usable skills is an action out of world. Understand "usable skills" and "use skill" and "use skills" as listing the usable skills.

Carry out listing the usable skills:
	[First, we count the number of skills the player can use.]
	now the first dummy is 0; now the second dummy is 0;
	repeat through the Table of Player Skills begin;
		if the have entry is 1 begin;
			if the curzeal entry is not greater than the zeal of the player, increase the first dummy by 1;
		end if;
	end repeat;
	if the first dummy is 0 begin;
		say "You cannot use any skill."; stop the action;
	end if;
	say "You can use the following skills: ";
	repeat through the Table of Player Skills begin;
		if the have entry is 1 begin;
			if the curzeal entry is not greater than the zeal of the player begin;
				increase the second dummy by 1;
				if the skill entry is not Greater Cleave begin; [TODO]
					say "[skill entry]";
					say " (",CurZeal entry, ")";
					if the second dummy + 1 is less than the first dummy, say ", ";
					if the second dummy + 1 is the first dummy, say " and ";
					if the second dummy is the first dummy, say ".";
				end if;
			end if;
		end if;
	end repeat.












Book 1.5 - Menu

Understand "menu" as asking for help.

Chapter 1.5.0.1 - The Menu Structure

When play begins:
     choose row 1 in Table of Basic Help Options;
     change description entry to "INTRODUCTION[paragraph break]You are currently playing Idols of War 0.1. [bold type]This is a Public Alpha[roman type]. It's aim is to test the use of tactical combat in interactive fiction. I am of course interested in specific things such as whether the current implementation is bug free, and whether the current skills are balanced, but even more important are the following questions:[line break]* Does Idols of War 0.1 present the results of combat and the various variables that have an effect on combat in a clear and concise manner?[line break]* Is it easy to interact with the combat system, to keep track of what is going on, and to learn how the system works?[line break]* Is the system sufficiently tactical? Which elements add to the tactical depth of the system, and which detract from it?[line break]* What features are missing to make the underlying system useful for authors who wish to implement tactical combat in their game?[paragraph break]AIMS[paragraph break]The main aim of Idols of War is to create a free software toolkit for interactive fiction authors who wish to implement tactical combat in their games. This toolkit has the current development name 'Inform ATTACK', which stands for 'Inform Advanced Turn-based TActical Combat Kit'.[paragraph break]KNOWN BUGS AND LIMITATIONS[paragraph break]* There is currently no AI implemented.[line break]* There is lots of missing content, including monster abilities; more locations; locations with special features; and higher level skills.[line break]* The source code will be released at a later stage, after clean-up, commenting and generalisation.[paragraph break]CONTACT[paragraph break]Please contact me with suggestions at victor@lilith.gotdns.org.";
     choose row 2 in Table of Basic Help Options;
     change title entry to "Standard Combat Actions";
     change subtable entry to Table of Actions Help.

Table of Basic Help Options (continued)
Title			Subtable		Description			Toggle
"Special Combat Modifiers"	      Table of Combat Specials		a text	  a rule
"Skills"		Table of Skills	a text				a rule


Chapter 1.5.0.2 - Actions Help


Table 43.1 - Actions Help
Title				Subtable		Description			Toggle
"Combat Basics"	--		"[combat basics first part][combat basics second part]"		--
"Attack"		--			"ATTACK[paragraph break]The most basic combat action is attacking. You will attempt to hit your enemy with your sword. If you deal damage to him, this will be subtracted from his Blood, which is good since he will die when his Blood drops to 0.[paragraph break]Everyone has a melee skill and a defence skill. (You can check out yours by typing 'Stats' at any point in the game.) You hit your enemy if a random roll between 1 and 10, plus your melee attack skill, is [italic type]higher[roman type] than his defence skill. Additional modifiers may apply, and will be detailed when the attack is attempted.[paragraph break][italic type]Grammar:[roman type] attack [italic type]opponent[roman type]; a [italic type]opponent[roman type]."			--
"Dodge"		--			"DODGE[paragraph break]When you dodge, you get ready to duck out of the way whenever your enemies try to hit you.[paragraph break]Dodging increases your defence by 2. In addition, dodging gives a +1 bonus to your melee. Dodging lasts until you attack, use an offensive skill or parry; but you can concentrate or use a defensive skill without breaking your dodge.[paragraph break][italic type]Grammar:[roman type] dodge; do."
"Parry"		--			"PARRY[paragraph break]When you parry, you strike up a defensive pose.[paragraph break]Parrying decreases the damage opponents deal to you by a random number between 0 and 4. In addition, parrying slightly improves the results of concentrating. Parrying lasts until you attack, use an offensive skill or dodge; but you can concentrate or use a defensive skill without breaking your parry.[paragraph break][italic type]Grammar:[roman type] parry; p."
"Concentrate"	--			"CONCENTRATE[paragraph break]When you concentrate, you are preparing to strike a more accurate and more devastating blow.[paragraph break]You build op concentration by concentrating for a number of turns. After one turn, you have mild concentration, which gives you a +2 to hit on your next attack. After two turns of concentration, you will have a +4 to hit and a +2 to damage. After three turns of concentrating, you will have a +8 to hit and a +4 to damage. You can slightly enhance these values by parrying while you concentrate. However, your concentration can also be broken! Retreating, moving, and using most skills will break your concentration, as will being damaged by your opponents.[paragraph break][italic type]Grammar:[roman type] concentrate; c."
"Retreat"		--			"RETREAT[paragraph break]If you fear to lose a fight, you can always attempt to retreat. Your chance of success depends on the numbers, health and speed of your opponents.[paragraph break]To successfully retreat, a random roll of one die must be higher than the total retreat score of your enemies. Each enemy you face contributes 1 to this total retreat score, with the following modifiers: particularly slow enemies contribute 0; particularly fast enemies contribute 2; contributions from enemies with more Blood than you have count double. Thus, a fast enemy with more Blood than you adds 4 to the total retreat score.[paragraph break][italic type]Grammar:[roman type] retreat."
"Statistics"		--			"STATISTICS[paragraph break]The most vital information about your character--her blood and zeal--is always displayed at the top of the screen. However, sometimes you may wish to review some more advanced information, such as which skills you have activated, how concentrated you are, what your melee modifier is, whether you are poisoned, and so forth. The statistics, or stats, command exists for this purpose. It will show you a brief overview of the current status of your character.[paragraph break][italic type]Grammar:[roman type] stats."
"Enemy statistics"	      --	      "ENEMY STATISTICS[paragraph break]A quick rundown of who your enemies are and how much Blood they have can be obtained by using the enemy stats command.[paragraph break][italic type]Grammar:[roman type] enemy stats; enemy; estats."

To say combat basics first part:
	say "COMBAT BASICS[paragraph break]Tactical combat plays an important role in [italic type]Idols of War[roman type]. So before you even start playing, you should familiarise yourself with the basics of the combat system.[paragraph break]Combat is [italic type]turn based[roman type]. This means that you get to take a single action, and than all the other characters present in the current location get to take a single action. Once everybody has done what they wish to, it is your turn again.[paragraph break]In combat, you will generally wish to take one of the standard combat actions or use one of the special skills you have learned. When the game starts, you know no special skills, so you don't have to worry about them until later. There are five standard combat actions, which you should know well if you wish to survive. If you wish to deal damage, you [bold type]attack[roman type]. If you wish to get less damage from the attacks of your opponents, you [bold type]parry[roman type]. If you wish to be hit less often, you [bold type]dodge[roman type]. If you wish to boost your chance to hit and your damage for the next attack, you [bold type]concentrate[roman type]. And if the combat proves too much for you, you [bold type]retreat[roman type]. For details,".
	
To say combat basics second part:
	say "read the descriptions of the individual actions.[paragraph break]When you attack, a virtual die is rolled to check if you hit. If you do hit, you deal an amount of damage--normally a random number between 1 and 6, but the amount can be increased or decreased by concentrating, using skills or items, or by special abilities of your opponents. When you deal damage, your opponent loses an amount of blood equal to the damage you dealt. As soon as the opponent has 0 or less damage, he is dead. If you kill all monsters in a location, you have won the fight.[paragraph break]If you keep losing a fight, try out different tactics. Maybe you need to concentrate more, to get your damage modifier up. Maybe you need to use a certain skills or get a certain kind of object. Or maybe you're just not good enough yet--you can always come back later and try again.[paragraph break]Don't forget to [bold type]save[roman type], but don't save too often: saving costs Zeal, which you also need to use your skills. The command [bold type]undo[roman type] is disabled in the current build of the game.".


Chapter 1.5.0.21 - Special Combat


Table of Combat Specials
Title					Subtable			Description		Toggle
"Deadly Combat"	 --				"DEADLY COMBAT[paragraph break]Consider the dynamics of fighting. Sometimes, people are hitting each other constantly. At other times, there is a temporary stand-off: everybody misses, they are concentrating or defending, or they are using non-offensive skills. During those moments, the tension is building--and the audience knows that the next blow is going to be important![paragraph break]That is the 'deadly combat' system of this game emulates. If nobody gets hit in an entire round of combat, then the deadly combat bonus is set to 1. This means that next turn, all combatants will have a +1 bonus to their attack roll and their damage. If nobody gets hit again, the bonus is raised to 2, then to 3, then to 4, and finally to a maximum of 5. If, on the other hand, a hit is scored in this round, then next round, the deadly combat bonus will be 2 lower than it currently is. (The minimum is always 0.)[paragraph break]It pays to keep an eye on the deadly combat bonus, which you can see in the status bar. You don't want to miss the opportunity to hit your opponent with a +5 bonus![paragraph break](Please note that several actions in this game, such as examining and looking, do not take any time. Thus, no round passes when you take them, and the deadly combat bonuses will not change.)"			a rule
"Excitement"		--				"EXCITEMENT[paragraph break]Excitement is a measure of your passion, anger, hatred, frustration--everything that drives you to prevail in combat. You start out Calm, but you can become Animated, Excited, Agitated, Frantic and Frenzied during the game. Higher states of excitement give you bigger combat bonuses.[paragraph break]You may gain Excitement by killing, by hitting and by being hit--this is randomly determined. There are also some skills and items that allow you to raise your excitement. On the opposite side, you'll gradually lose Excitement when you are not in combat, and you can lower it yourself by either concentrating or calming down. (Why would you ever want to lower it? Because if you get [italic type]too[roman type] excited, you'll suffer a fatal heart attack! You must walk a fine line here.)"			--
"Beat"				--				"BEAT[paragraph break]Many locations in the game have a beat. This beat is a rhythm that defines the ideal moments to strike a blow. In the status bar, you will see two thing: when the next beat arrives, and what the beat bonus will be. In the round that the beat is there and the bonus is active, you will see 'Next Beat: now'.[paragraph break]The beat bonus has two effects. First, for everyone in the location, the beat bonus acts as a damage bonus. So every attack deals more damage when the beat is there. Second, and applying to you only, the Blood you receive when you kill an enemy is also increased by the beat bonus. So if you'd normally receive 4 Blood for an enemy, and the beat is there, and the beat bonus is 3, you'll now receive 7 Blood for that enemy. So paying attention to the beat is very useful!"			--
"Zeal and Favour"				--				"ZEAL AND FAVOUR[paragraph break]Zeal measures your standing with the Gods of War. You will need Zeal to use special skills taught by the Gods. The Status Bar shows two values: the first is your current Zeal, the second is your maximum Zeal. In general, your current Zeal cannot be higher than your maximum Zeal.[paragraph break]Your Zeal decreases when you use special skills. This decrease is not constant, but depends on the number of times you've already used that skill since the last time you won a combat. A skill that costs 1 Zeal the first time you use it will cost 2 Zeal the second time, 3 Zeal the third time, and so on. So as you acquire more skills, it's a good idea to use all of them rather than rely on only a few.[paragraph break]Another factor that affects Zeal cost is which of the Gods currently favour or disfavour you. If a God favours you, it's as if you used all of his skills one less time than you actually did--which means that your first use of each skill of a God that favours you is actually [italic type]free[roman type]! If a God disfavours you, it's as if you have used all their skills one more time than you actually have.[paragraph break]Your Zeal increases when you win particularly hard fights."			--


Chapter 1.5.0.3 - Skills Help



Table 1.5.0.3.0 - Skills
Title					Subtable			Description			Toggle
"How do skills work?"	--		"WHAT ARE SKILLS?[paragraph break]Your character knows several standard combat moves, such as attacking, dodging, parrying and concentrating, but those moves will not be enough to grant her victory in all the many fights she will find herself in. Luckily, the Gods of War are willing to teach her special skills that give her new and powerful tactical options.[paragraph break]WHAT SKILLS CAN I LEARN?[paragraph break]In the previous menu (which you can always view by typing 'skills'), you saw entries for each of the four Gods of War. Following these will show you lists of all the skills the respective Gods can teach you. Selecting those skills will give you a description.[paragraph break]WHAT SKILLS DO I HAVE?[paragraph break]You start the game with no skills at all, but will gradually learn more. During the game, you can always type 'list skills' in order to review the skills you have, and 'use skills' to see which ones you can currently use and how much Zeal that will cost you.[paragraph break]HOW DO I LEARN SKILLS?[paragraph break]You learn skills by finding diamonds and throwing them into the mouths of the Gods. So if you wish to learn a Groth skill, you must put a diamond into Groth's mouth.[paragraph break]HOW DO I USE SKILLS?[paragraph break]Every skill description contains a grammar entry, which tells you the right command to use that skill. (Some skills are automatic and need not be activated.) Using a skill costs Zeal: if you do not have enough Zeal, you cannot use the skill. You can always type 'use skills' to find out which skills you can currently use."	a rule
"Groth's Skills"		Table of Groth's Skills	--
"Elda's Skills"		Table of Elda's Skills
"Duncan's Skills"	Table of Duncan's Skills
"Shliss's Skills"		Table of Shliss Skills





Table 1.5.0.3.1 - Groth's Skills
Title					Subtable			Description			Toggle
"Smashing Blow"	--			"SMASHING BLOW[paragraph break]Groth lends strength to your attack, allowing you to do extra damage. If you miss, the blow is wasted. If you hit, a die is rolled to calculate the effect: you have a one in six chance of doing 1, 2, 3, 4, 6 or 8 extra damage. Smashing blow counts as a regular melee attack.[paragraph break][italic type]Grammar:[roman type] smash [italic type]opponent[roman type].[paragraph break][italic type]Level:[roman type] 1[paragraph break][italic type]Cost to use:[roman type] 1 zeal."
"Greater Cleave"			--			"GREATER CLEAVE[paragraph break]Normally, a cleave bonus attack is made with a melee modifier of half the excess of the previous attack, and a damage modifier of half the excess of the previous attack. If you have the Greater Cleave automatic skill, you will get both modifiers in full, this enhancing the chances of success of your cleave attacks.[paragraph break][italic type]Grammar:[roman type] (none -- this skill is automatic).[paragraph break][italic type]Level:[roman type] 1[paragraph break][italic type]Cost to use:[roman type] (none -- this skill is automatic)."
"Anger"			--			"ANGER[paragraph break]Groth fills your mind with red-hot anger. Your excitement temporarily increases by one stage, and you will get all the associated bonuses. Your anger subsides as soon as you are in a location without living enemies.[paragraph break][italic type]Grammar:[roman type] anger; angry; become angry.[paragraph break][italic type]Level:[roman type] 1[paragraph break][italic type]Cost to use:[roman type] 1 zeal."
"Deadlier Combat"	--			"DEADLIER COMBAT[paragraph break]Only the brave call on the power of Groth to make the fight they find themselves in more deadly. Once deadlier combat has been granted, the damage bonus granted by deadly combat is doubled. So if the deadly combat bonus is 2, all attacks will be made at +2 attack and +4 damage. This effect lasts until the end of the fight. Asking for deadlier combat is a free action.[paragraph break][italic type]Grammar:[roman type] deadlier combat.[paragraph break][italic type]Level:[roman type] 1[paragraph break][italic type]Cost to use:[roman type] 1 Zeal."

["Fury"			--			"FURY[paragraph break]Groth fills your mind with white-hot fury. As long as you are furious, you have a +2 bonus to damage on all your melee attacks. On the negative side, as long as you are furious you cannot retreat, defend or use defensive skills, and concentrating has a 50% chance to fail. Fury lasts as long as the current combat, or until you become enraged. Becoming furious is a free action.[paragraph break][italic type]Grammar:[roman type] fury; furious; become furious.[paragraph break][italic type]Cost to learn:[roman type] 2 Groth Idols.[paragraph break][italic type]Cost to use:[roman type] 1 Zeal if already angry; 2 Zeal otherwise."
"Armour of Blood"			--			"ARMOUR OF BLOOD[paragraph break]Being able to deal loads of damage is all very well, but it will little avail you if you're dead. Groth frowns on normal armour, but he does grant the Armour of Blood to his beloved fighters. It gives you a bonus to your defence against the next attack equal to the damage you received from the current attack. So if you are hit for 3 damage, you will have +3 defence against the next attack. The armour lasts as long as the current combat, or until you get another armour. Getting the armour is a standard action.[paragraph break][italic type]Grammar:[roman type] armour of blood.[paragraph break][italic type]Cost to learn:[roman type] 2 Groth Idols.[paragraph break][italic type]Cost to use:[roman type] 2 Zeal."
]


Table 1.5.0.3.2 - Elda's Skills
Title					Subtable			Description			Toggle
"Bronze Armour"	--			"BRONZE ARMOUR[paragraph break]Through Elda's subtle magics, a suit of armour seemingly made of bronze will form around you. Whenever an enemy hits you, the suit has a 50% chance of absorbing up to 3 damage. In addition, Bronze Armour's damage resistance slightly increases as combat deadliness goes up--so it helps takes the worst edge off particularly painful attacks. On the negative side, Bronze Armour gives you a -1 melee penalty. After four hits, or when the fight ends, the suit will disappear.[paragraph break][italic type]Grammar:[roman type] bronze armour.[paragraph break][italic type]Level:[roman type] 1[paragraph break][italic type]Cost to use:[roman type] 1 Zeal."				a rule
"Curse"	--			"CURSE[paragraph break]With this skill, you can curse a single opponent. That opponent will then have a -4 modifier to all his melee attacks against you, which lasts until he manages to hit you despite this penalty.[paragraph break][italic type]Grammar:[roman type] curse [italic type]opponent[roman type].[paragraph break][italic type]Level:[roman type] 1[paragraph break][italic type]Cost to use:[roman type] 1 Zeal."
"Shield"	--			"SHIELD[paragraph break]When Shield is active, the parrying action becomes more effective. Instead of reducing all damage dealt to you by 0 to 4 damage, parrying will now take away between 2 and 6 damage. Note that Shield by itself doesn't do anything: you must parry in order to get the bonus.[paragraph break][italic type]Grammar:[roman type] shield.[paragraph break][italic type]Level:[roman type] 1[paragraph break][italic type]Cost to use:[roman type] 1 Zeal."
"Gaseous Form"	--			"GASEOUS FORM[paragraph break]For one turn, you will turn into an insubstantial being. Nobody and nothing will be able to hit you while you are gaseous, essentially making you immune from attacks for a single round.[paragraph break][italic type]Grammar:[roman type] gaseous form; gaseous.[paragraph break][italic type]Level:[roman type] 1[paragraph break][italic type]Cost to use:[roman type] 1 Zeal."



Table 1.5.0.3.3 - Duncan's Skills
Title					Subtable			Description			Toggle
"Burning Hands"	--			"BURNING HANDS[paragraph break]When you try to burn an opponent, you have to walk right up to him--which means that he first gets a free attack against you. Irrespective of whether he hits or misses, you then get to make an attack against him at a +1 bonus. If you hit, the enemy will not only receive 1 to 3 damage, he will also have a 2 in 3 chance of catching fire. This fire deals 1 to 5 damage every turn for 5 turns--so that's another 5 to 25 damage.[paragraph break][italic type]Grammar:[roman type] burn [italic type]item[roman type]; burn [italic type]opponent[roman type].[paragraph break][italic type]Level:[roman type] 1.[paragraph break][italic type]Cost to use:[roman type] 1 Zeal."				a rule
"Summon Imps"	--			"SUMMON IMPS[paragraph break]You summon three small creatures to your aid. They generally have 3 Blood, a melee score of 0, a defence score of 0, and deal between 1 and 2 damage, although each of them has a specific bonus. They will attack your enemies every turn, and sometimes your enemies will attack them instead of you.[paragraph break]There is one drawback to this spell: the loyalty of the imps is very fickle, and they may turn against you. This can happen occasionally during the fight, but if they are still alive when your enemies are defeated, they will turn against you for certain.[paragraph break][italic type]Grammar:[roman type] summon imps; imps.[paragraph break][italic type]Level:[roman type] 1.[paragraph break][italic type]Cost to use:[roman type] 2 Zeal."
"Scout"		--			"SCOUT[paragraph break]The scouting skill allows you to explore new territory without too much danger. If you scout a direction instead of simply going to it, you will then receive a +4 bonus on all attempts to retreat from that location. The scouting bonus disappears once you take an offensive action, such as attacking.[paragraph break][italic type]Grammar:[roman type]scout [italic type]direction[roman type].[paragraph break][italic type]Level:[roman type] 1.[paragraph break][italic type]Cost to use:[roman type] 1 Zeal."
"Fire Bomb"	--			"FIRE BOMB[paragraph break]You drop a small explosive device on the battlefield, which explodes in 1d3 round. Once it explodes, all your enemies have a 2 in 3 chance of catching fire, in which case the flames will deal them 1 to 5 damage for 5 consecutive rounds. There is also a 1 in 3 chance that [italic type]you[roman type] will catch fire.[paragraph break][italic type]Grammar:[roman type] fire bomb; bomb.[paragraph break][italic type]Level:[roman type] 1.[paragraph break][italic type]Cost to use:[roman type] 2 Zeal."




Table 1.5.0.3.4 - Shliss Skills
Title					Subtable			Description			Toggle
"Needle"	--			"NEEDLE[paragraph break]A needle speeds from your hand at the designated enemy. It has a 5 in 6 chance of hitting, and does 2 damage. The needle is so sharp that it bypasses normal damage reduction (such as is afforded by a thick hide or carapace).[paragraph break][italic type]Grammar:[roman type] needle [italic type]opponent[roman type].[paragraph break][italic type]Level:[roman type] 1.[paragraph break][italic type]Cost to use:[roman type] 1 Zeal."				a rule
"Determination"	--			"DETERMINATION[paragraph break]When you are determined, you have a chance to stay concentrated even when you receive damage. A random number between 1 and 6 is chosen when you are damaged; if this number is equal to or exceeds the amount of damage you received, your concentration will not be broken. Determination lasts until the end of combat. Becoming determined is a free action.[paragraph break][italic type]Grammar:[roman type] determination; det.[paragraph break][italic type]Level:[roman type]1.[paragraph break][italic type]Cost to use:[roman type] 2 Zeal."
"Sacrifice"	--			"SACRIFICE[paragraph break]You choose an amount of Blood you wish to sacrifice. On your next attack, you deal that much extra damage if you hit.[paragraph break][italic type]Grammar:[roman type] sacrifice [italic type]n[roman type].[paragraph break][italic type]Level:[roman type]1.[paragraph break][italic type]Cost to use:[roman type] 1 Zeal."
"Await"	--			"AWAIT[paragraph break]The result of awaiting is that after [italic type]n[roman type] turns, you can make an attack with a + [italic type]n[roman type] melee bonus that also does + [italic type]n[roman type] damage. So, 'await 3' will allow you to make an attack with a +3 melee and damage bonus 3 rounds from now.[paragraph break]However, there is one important restriction: while you are awaiting your chance, you are not allowed to attack or take another offensive action (such as using Smashing Blow or Burning Hands). If you do attack early, your await bonus is cancelled. (This means that although 'await 20' would give you a massive bonus after 20 turns, you'd also have to refrain from attacking for 19 turns first, which is not so good.) You can dodge, parry, concentrate or use defensive skills while you are awaiting.[paragraph break][italic type]Grammar:[roman type] await [italic type]n[roman type].[paragraph break][italic type]Level:[roman type]1.[paragraph break][italic type]Cost to use:[roman type] 2 Zeal."


["Crackling Weapon"	--			"CRACKLING WEAPON[paragraph break]Shliss charges your melee weapon with fearsome but dangerously unpredictable electrical energy. Whenever you hit, a die is rolled to calculate the effect: on a 1, 2 or 3, nothing happens; on a 4, your enemy receives 2 extra electrical damage; on a 5, your enemy receives 4 extra electrical damage; but on a 6, [italic type]you[roman type] receive 3 electrical damage as the energy lashes back at you. Crackling weapon lasts until the end of the combat. Getting Shliss to imbue your weapon is a standard action.[paragraph break][italic type]Grammar:[roman type] crackling weapon.[paragraph break][italic type]Cost to learn:[roman type] 1 Shliss Idol.[paragraph break][italic type]Cost to use:[roman type] 1 Zeal."]




Book 1.6 - New Actions


Chapter 1.6.0.1 - Swimming

Swimming is an action applying to nothing. Understand "swim" and "dive" as swimming. Instead of swimming: say "There is no suitable body of water here.".


Chapter 1.6.0.2 - New grammar for entering

Understand "go through [thing]" as entering. Understand "go behind [thing]" as entering.


Chapter 1.6.0.3 - Xyzzy

Xyzzying is an action applying to nothing. Understand "xyzzy" as xyzzying.

Instead of xyzzying:
	say "Uh-oh. That was [italic type]not[roman type] a good idea.";
	now the xyzzied tarrasque is in the location;
	calculate the initial combat significance;
	now the combat boolean is 1.


Chapter 1.6.0.4 - Throwing

Throwing is an action applying to one thing. Understand the command "throw" as something new. Understand "throw [a thing]" as throwing.

Instead of throwing something: say "Only missile weapons can be thrown.".


Chapter 1.6.0.5 - Talking to

A person is either talkative, limited-talkative or dumb. A person is usually dumb.

A person has a table-name called the responses.

The responses of a person is usually the Table of Silence.

Table of Silence
topic					response				link				done		repeating		summary
"the weather"			"You have nothing to say to each other."		c_silence		0		1		a text

c_silence is a chat node.

Instead of giving link to c_silence: do nothing.
Instead of giving text for c_silence: do nothing.
Instead of finding responses to c_silence: forbid exiting on zero; do nothing.



Instead of asking someone about something:
	try telling the noun about it.

Understand "t [a person] about [text]" and "t [a person] [text]" and "talk to [a person] about [text]" and "talk to [a person] [text]" and "t to [a person] about [text]" and "t to [a person] [text]" as telling it about.


Talking to is an action applying to one visible thing. Understand "talk to [person]" and "speak to [person]" and "talk with [person]" and "speak with [a person]" and "t to [a person]" and "t [a person]" as talking to.

A person has a text called the standard topic. The standard topic of a person is usually "the weather".



Carry out talking to:
	say "You will have to specify what you wish to talk about. In this case, I would suggest the topic '[the standard topic of the noun]'. (Type 't [the noun] [the standard topic of the noun]'.)".



Instead of telling someone about something:
	if the noun is killed, say "The only sound emanating from the corpse is that of slow putrefaction." instead;
	if the noun is dumb, say "You cannot converse with [the noun]." instead;
	if the noun is limited-talkative begin;
		say "(I'd love to tell you what the only subject is you can talk about with [the noun], but that currently produces a fatal error in Gargoyle. So I can't.)[paragraph break]";
	end if;
	let the source be the responses of the noun;
	sort source in done order;
	if topic understood is a topic listed in source begin;
		if the done entry is greater than 1 and the repeating entry is 0 begin;
			say "[The noun] has already told you [summary entry].";
		otherwise;
			now the done entry is 3 minus the done entry; [0 -> 3, 1 -> 2]
			if there is a response entry, say "[response entry][paragraph break]";
			if there is a link entry, run a conversation from link entry;
		end if;
	otherwise;
		say "You can't talk about that with [the noun].";
	end if. 






Book 1.7 - Miscellaneous


Chapter 1.7.0.1 - Determinable Kind

A determinable is a kind of thing.

A determinable is usually scenery. The description of a determinable is usually "ERROR: you should never see this text.".

The global determinable is a determinable that varies.

A determinable has a number called the determinate number. The determinate number of a determinable is usually 0.

[A determinable has an indexed text called the referencing name. Understand the referencing name property as describing a determinable. The referencing name of a determinable is usually "abcdefghijklmnopqrtsuvwxyz".] [THIS IS THE LINE!]
A determinable has a number called the options number.
A determinable has some text called the current room description text.
A determinable has some text called the first option text.
A determinable has some text called the first room description text.
A determinable has some text called the first description text.
A determinable has some text called the first printed text.
A determinable has a number called the first spirit. The first spirit is usually 0.
A determinable has some text called the second option text.
A determinable has some text called the second room description text.
A determinable has some text called the second description text.
A determinable has some text called the second printed text.
A determinable has a number called the second spirit. The second spirit is usually 0.
A determinable has some text called the third option text.
A determinable has some text called the third room description text.
A determinable has some text called the third description text.
A determinable has some text called the third printed text.
A determinable has a number called the third spirit. The third spirit is usually 0.

Before examining a determinable:
	if the determinate number of the noun is 0 begin; 
		now the global determinable is the noun;
		run a conversation from c_determinable_1;
		stop;
	end if.


c_determinable_1, c_determinable_2, c_determinable_3, c_determinable_4 are chat nodes.

Instead of giving text for c_determinable_1: say "Well, what [italic type]do[roman type] you see?".
Instead of finding responses to c_determinable_1: forbid exiting on zero; link to c_determinable_2; if the options number of the global determinable is greater than 1, link to c_determinable_3; if the options number of the global determinable is greater than 2, link to c_determinable_4.

Instead of giving link to c_determinable_2: say "[first option text of the global determinable][if the first spirit of the global determinable is greater than 0][bold type] (+ [first spirit of the global determinable] Spirit)[roman type][end if][if the first spirit of the global determinable is less than 0][bold type] ([first spirit of the global determinable] Spirit)[roman type][end if][paragraph break]".
Instead of giving text for c_determinable_2: say "".
Instead of finding responses to c_determinable_2: now the determinate number of the global determinable is 1; now the current room description text of the global determinable is the first room description text of the global determinable; now the printed name of the global determinable is the first printed text of the global determinable; now the description of the global determinable is the first description text of the global determinable[; now the referencing name of the global determinable is the second room description text of the global determinable]; say "Right, [the global determinable]."; increase the spirit of the player by the first spirit of the global determinable.

Instead of giving link to c_determinable_3: say "[second option text of the global determinable][if the second spirit of the global determinable is greater than 0][bold type] (+ [second spirit of the global determinable] Spirit)[roman type][end if][if the second spirit of the global determinable is less than 0][bold type] ([second spirit of the global determinable] Spirit)[roman type][end if][paragraph break]".
Instead of giving text for c_determinable_3: say "".
Instead of finding responses to c_determinable_3: now the determinate number of the global determinable is 2; now the current room description text of the global determinable is the second room description text of the global determinable; now the printed name of the global determinable is the second printed text of the global determinable; now the description of the global determinable is the second description text of the global determinable[; now the referencing name of the global determinable is the printed name of the global determinable]; say "Right, [the global determinable]."; increase the spirit of the player by the second spirit of the global determinable.

Instead of giving link to c_determinable_4: say "[third option text of the global determinable][if the third spirit of the global determinable is greater than 0][bold type] (+ [third spirit of the global determinable] Spirit)[roman type][end if][if the third spirit of the global determinable is less than 0][bold type] ([third spirit of the global determinable] Spirit)[roman type][end if][paragraph break]".
Instead of giving text for c_determinable_4: say "".
Instead of finding responses to c_determinable_4: now the determinate number of the global determinable is 3; now the current room description text of the global determinable is the third room description text of the global determinable; now the printed name of the global determinable is the third printed text of the global determinable; now the description of the global determinable is the third description text of the global determinable[; now the referencing name of the global determinable is the printed name of the global determinable]; say "Right, [the global determinable]."; increase the spirit of the player by the third spirit of the global determinable.


The undetermined thing is a determinable. [This is a dummy object that serves as a template for other determinables.]

The options number of the undetermined thing is 3.
The current room description text of the undetermined thing is "What goes in the room description.".
The first option text of the undetermined thing is "Choose the first option.".
The first room description text of the undetermined thing is "Room description of the first option.".
The first description text of the undetermined thing is "Describing the first option.".
The first printed text of the undetermined thing is "Printed text of first option.".
The second option text of the undetermined thing is "Choose the second option.".
The second room description text of the undetermined thing is "Room description of the second option.".
The second description text of the undetermined thing is "Describing the second option.".
The second printed text of the undetermined thing is "Printed text of second option.".
The third option text of the undetermined thing is "Choose the third option.".
The third room description text of the undetermined thing is "Room description of the third option.".
The third description text of the undetermined thing is "Describing the third option.".
The third printed text of the undetermined thing is "Printed text of third option.".


Chapter 1.7.0.2 - Detailer Kind

A detailer is a kind of thing. A detailer is always scenery. [Examining detailers changes the room description. The idea is that you can have a terse room description, which is fleshed out with detail as the player examines more objects.]

A detailer has some text called the current room description text.
A detailer has some text called the detailed room description text.

Before examining a detailer:
	now the current room description text of the noun is the detailed room description text of the noun.




Chapter 1.7.0.3 - Dungeons


A dungeon is a kind of region.

Before printing the name of a room in a dungeon:
	say "[bracket]D[close bracket] ".

Dungeon-kinship relates rooms to each other in groups. The verb to be dungeon-kin to implies the dungeon-kinship relation.

[When play begins:
	repeat with the original room running through rooms begin;
		if the original room is in a dungeon begin;
			repeat with the potential kin running through rooms adjacent to the original room begin;
				if the potential kin is in a dungeon, now the potential kin is dungeon-kin to the original room;
			end repeat;
		end if;
	end repeat.]


[Every turn:
	repeat with k running through dungeons begin;
		 if no alive monster is in k and the location of the player is not in k begin;
			repeat with the sucker running through monsters in k begin;
				now the blood of the sucker is the permanent blood of the sucker;
				now the room dummy is a random room in k;
				move the sucker to the room dummy;
			end repeat;
			repeat with the treasure running through things in the cache of k begin;
				if a random chance of 1 in 5 succeeds begin;
					say k;
					move the treasure to a random treasure chest in k;
				end if;
			end repeat;
			repeat with the chest running through treasure chests in k begin;
				now the chest is closed;
			end repeat;
		end if;
	end repeat.]

Every turn:
	 if no alive monster is in the Bat Cave and the location of the player is not in the Bat Cave begin;
		repeat with the sucker running through monsters in the Bat Cave begin;
			now the blood of the sucker is the permanent blood of the sucker;
			now the room dummy is a random room in the Bat Cave;
			move the sucker to the room dummy;
		end repeat;
		repeat with the treasure running through things in the cache of the Bat Cave begin;
			if a random chance of 1 in 5 succeeds begin;
				move the treasure to a random treasure chest in the Bat Cave;
			end if;
		end repeat;
		repeat with the chest running through treasure chests in the Bat Cave begin;
			now the chest is closed;
		end repeat;
	end if.

Every turn:
	 if no alive monster is in the Forest and the location of the player is not in the Forest begin;
		repeat with the sucker running through monsters in the Forest begin;
			now the blood of the sucker is the permanent blood of the sucker;
			now the room dummy is a random room in the Forest;
			move the sucker to the room dummy;
		end repeat;
		repeat with the treasure running through things in the cache of the Forest begin;
			if a random chance of 1 in 5 succeeds begin;
				move the treasure to a random treasure chest in the Forest;
			end if;
		end repeat;
		repeat with the chest running through treasure chests in the Forest begin;
			now the chest is closed;
		end repeat;
	end if.


A treasure chest is a kind of container. A treasure chest is usually openable, closed and scenery.

A dungeon has a treasure chest called the cache.



Chapter 1.7.0.4 - Visbility

A room has a number called the room visibility. The room visibility of a room is usually 0. [Darker rooms get lower, therefore NEGATIVE, room visibility.]

Total visibility is a number that varies. The total visibility is usually 0. [This is the global variable that tracks how dark a room is.]

A person is either darkvisioned or not darkvisioned. A person is usually not darkvisioned. [Darkvisioned persons disregard all darkness.]

A person is either lowlightvisioned or not lowlightvisioned. A person is usually not lowlightvisioned. [Lowlightvisioned person disregard up to two levels of darkness.]

A thing has a number called the illumination. The illumination of a thing is usually 0.


To determine visibility:
	now the total visibility is the room visibility of the location;
	if the total visibility is 0, stop; [Only go on to search for light sources if the room is dark]
	repeat with the potential light source running through things enclosed by the location begin;
		if the potential light source is visible begin;
			if the potential light source is an on fire person, increase the total visibility by 2;
			increase the total visibility by the  illumination of the potential light source;
		end if;
	end repeat;
	if the total visibility is greater than 0, now the total visibility is 0.


An always-present attack modifiers rule (this is the visibility attack penalties rule):
	determine visibility; [Visibility]
	if the total visibility is less than 0 begin;
			now the first dummy is the total visibility;
			if the global attacker is darkvisioned, now the first dummy is 0;
			if the global attacker is lowlightvisioned and the first dummy is less than 0, increase the first dummy by 1;
			if the global attacker is lowlightvisioned and the first dummy is less than 0, increase the first dummy by 1;
			if the global defender is on fire, now the first dummy is 0; [You can easily someone who is on fire!]
			if the hold location of the global defender is not 0  and the first dummy is less than 0, increase the first dummy by 1; [Its easier to hit someone who is holding on to you/someone else.]
			now the first dummy is 0 minus the first dummy;
			if the first dummy is not 0, say " - ", first dummy, " (low visibility)[run paragraph on]";
			decrease the to-hit modifier by the first dummy;
	end if;




Volume 2 - Monsters, Player, Combat Items



Chapter 2.0.0.1 - The Player Character


Section 2.0.0.1.1 - Statistics

[Here we define the initial statistics of the player character.]

The blood of the player is 20.
The zeal of the player is 10.
The melee of the player is 1.
The mind of the player is 1.
The defence of the player is 7. 

The player has a number called the spirit. The spirit of the player is 0.


Section 2.0.0.1.2 - Leveling up

[The player starts on level 1, and proceeds to level 5. There is a one-to-one correspondence between "player level" and "dungeon level", and for the game we will make them semantically the same concept. Also, we will use monster level to find out how cool it is to fight them; but this works a little differently - see 2.0.0.2.2.]

A person has a number called level. The level of the player is 1. [We modify the status bar in section 2.2.]

[Now we define the activity of leveling up.]

To level up:
   increase the level of the player by 1;
   increase the permanent blood of the player by 10;
   increase the permanent zeal of the player by 10;
   restore the blood of the player;
   restore the zeal of the player;
   increase the mind of the player by 1;
   increase the melee of the player by 1;
   increase the defence of the player by 1;
   say "You have gained a level! The Gods reward you accordingly.".


Section 2.0.0.1.3 - Appearance and initial possessions

Instead of examining the player:
	if the level of the player is 1, say "Strong. Competent. Someone who is not going to be stopped.";
	if the level of the player is 2, say "TODO";
	if the level of the player is 3, say "TODO";
	if the level of the player is 4, say "TODO";
	if the level of the player is 5, say "TODO".
	
Golden hair is a part of the player. Understand "blond" as the golden hair. Instead of examining the golden hair:
	if the level of the player is 1, say "Long, sleek, golden--it reflects the light with metallic purity.";
	if the level of the player is 2, say "TODO";
	if the level of the player is 3, say "TODO";
	if the level of the player is 4, say "TODO";
	if the level of the player is 5, say "TODO".

The player carries a sword. The sword is a determinable. The sword is not scenery. Understand "ornate" and "huge" and "practical" as the sword.

The options number of the sword is 3.
The first option text of the sword is "It is a grand and majestic sword: the blade has been inlaid with platinum designs, while the hilt is encrusted with big jewels encased in purest gold. This is the kind of blade that makes people [italic type]adore[roman type] and [italic type]respect[roman type] you.".
The first description text of the sword is "It is a grand and majestic sword: the blade has been inlaid with platinum designs, while the hilt is encrusted with big jewels encased in purest gold. This is the kind of blade that makes people [italic type]adore[roman type] and [italic type]respect[roman type] you.".
The first printed text of the sword is "ornate sword".
The second option text of the sword is "The sword is huge and made of an unknown, deeply black metal. The pommel is shaped as a skull. This is the kind of blade that makes people [italic type]fear[roman type] and [italic type]obey[roman type] you.".
The second description text of the sword is "The sword is huge and made of an unknown, deeply black metal. The pommel is shaped as a skull. This is the kind of blade that makes people [italic type]fear[roman type] and [italic type]obey[roman type] you.".
The second printed text of the sword is "huge sword".
The third option text of the sword is "The sword is short and sharp, well-balanced and well-maintained, but its appearance is entirely mundane. This is the kind of blade that nobody looks at twice.".
The third description text of the sword is "The sword is short and sharp, well-balanced and well-maintained, but its appearance is entirely mundane. This is the kind of blade that nobody looks at twice.".
The third printed text of the sword is "practical".


Instead of dropping the sword: say "You don't want to walk around without a sword.". Instead of putting the sword on something: say "You don't want to walk around without a sword.". Instead of inserting the sword into something: say "You don't want to walk around without a sword.". 

[The player carries four groth idols, four shliss idols, three duncan idols and three elda idols.] [TODO]


Section 2.0.0.1.4 - Responses to standard actions

Instead of waking up: say "You have never been more awake in your life.".

Instead of kissing: say "You are not exactly in a friendly mood.".

[Instead of answering that: say "You cannot talk. You do not have a tongue.".
Instead of telling something about: say "You cannot talk. You do not have a tongue.".
Instead of asking something about: say "You cannot talk. You do not have a tongue.".
Instead of asking something for: say "You cannot talk. You do not have a tongue.".
Instead of saying sorry: say "You cannot talk. You do not have a tongue.".
Instead of swearing mildly: say "You cannot talk. You do not have a tongue.".
Instead of swearing obscenely: say "You cannot talk. You do not have a tongue.".]

Instead of saying yes: say "You nod your assent.".
Understand "nod" as saying yes.

Instead of saying no: say "You shake your head in dissent.".

Instead of waiting: say "You freeze.".

Instead of waving hands: say "You wave your sword in a threatening manner.".

Instead of jumping: say "You jump forward, as deadly as a viper.".

Instead of singing: say "You hum a tune that, somewhere, somewhen, will be known as the Ride of the Valkyries.".

Instead of sleeping: say "If you do not stay awake, you will soon be sleeping the sleep of Death.".


Section 2.0.0.1.5 - The Stats action

Showing the stats is an action out of world. Understand "stats" and "statistics" and "diagnose" and "show stats" as showing the stats.


Carry out showing the stats:
	say "[bold type]Your statistics:[roman type][line break]";
	say " Blood: ", blood of the player, " out of ", permanent blood of the player, "[line break]";
	say " Zeal: ", zeal of the player, " out of ", permanent zeal of the player, "[line break]";
	say " Melee: ", melee of the player, "[line break]";
	say " Defence: ", defence of the player, "[line break]";
	say " Standard damage: 1 to ", damage die of the player, "[line break]";
	say "[line break]";
	say "[bold type]Special conditions:[roman type][line break]";
	if the player is at dodge, say " Dodging (+2 defence; +1 melee)[line break]";
	if the player is at parry and the player is not shielded, say " Parrying (damage reduction, 1 to 4)[line break]";
	if the player is shielded and the player is at parry, say " Parrying and Shield (damage reduction, 2 to 6)[line break]";
	if the player is shielded and the player is not at parry, say " Shield (increases effectiveness of Parry)[line break]";
	if the concentration of the player is greater than 0 and the player is not at parry begin;
		if the concentration of the player is 1, say " Concentrated (+2 melee on your attack)[line break]";
		if the concentration of the player is 2, say " Concentrated (+4 melee and +2 damage on your next attack)[line break]";
		if the concentration of the player is 3, say " Concentrated (+8 melee and +4 damage on your next attack)[line break]";
	end if;
	if the concentration of the player is greater than 0 and the player is at parry begin;
		if the concentration of the player is 1, say " Concentrated (+2 melee on your attack)[line break]";
		if the concentration of the player is 2, say " Concentrated (+5 melee and +3 damage on your next attack)[line break]";
		if the concentration of the player is 3, say " Concentrated (+10 melee and +5 damage on your next attack)[line break]";
	end if;
	if the deadly combat bonus is greater than 0, say " Deadly Combat (currently +", deadly combat bonus," melee and damage for all characters)[line break]";
	if the deadlier combat boolean is true and the deadly combat bonus is greater than 0, say " Deadlier Combat (an additional +", deadly combat bonus," damage bonus for all characters)[line break]";
	if the beat count is 0 and the beat strength is not 0 and the beat is not 0 begin;
		say " Beat (a + ", beat strength, " bonus to everyone's damage)[line break]";
	end if;
	if the player is serene, say " Serene (-1 melee, -3 damage, +1 defence)[line break]";
	if the player is calm, say " Calm (-1 damage, +1 defence)[line break]";
	if the player is animated, say " Animated (no bonus or penalty)[line break]";
	if the player is excited, say " Excited (+1 damage)[line break]";
	if the player is agitated, say " Agitated (+1 melee, +2 damage)[line break]";
	if the player is frantic, say " Frantic (+2 melee, +4 damage, -1 defence)[line break]";
	if the player is frenzied, say " Frenzied (+4 melee, +8 damage, -2 defence)[line break]"; 
	if the player is angry, say " Angry (+1 excitement)[line break]";
	if the elda armour status of the player is greater than 0 begin;
		if the elda armour metal is bronze, say " Bronze armour";
		if the elda armour metal is iron, say " Iron armour";
		if the elda armour metal is steel, say " Steel armour";
		say " (a [elda percentage]% chance of absorbing up to ";
		now the first dummy is the elda armour amount of the player;
		if the deadly combat bonus is greater than 2, increase the first dummy by 1;
		if the deadly combat bonus is greater than 4, increase the first dummy by 1;
		say first dummy, " damage up to ", elda armour status of the player, " more times; and a -1 melee penalty)[line break]";
	end if;
	if the player is cursed, say " Cursed (-4 melee modifier until curse is lifted)[line break]";
	if the player is gaseous, say " Gaseous (cannot be attacked this turn)[line break]";
	if the scouting boolean is true, say " Scouting (+4 bonus to retreat)[line break]";
	if the player is determined, say " Determined (you sometimes keep your concentration even if you are damaged)[line break]";
	if the sacrificial number of the player is greater than 0, say " Sacrifice (+", the sacrificial number of the player," melee on your next attack)[line break]";
	if the player is poisonous, say " Poisoned (receive between ", minimum poison damage of the player, " and ", maximum poison damage of the player, " damage for ", poison time of the player, " more turns)[line break]";
	if the player is on fire, say " Burning (receive between ", minimum burn damage of the player, " and ", maximum burn damage of the player, " damage for ", burn time of the player, " more turns)[line break]";
	if the global guarding stick number is greater than 0, say "Stick of Guarding (+",  global guarding stick number," defence)[line break]";
	determine visibility;
	if the total visibility is less than 0 begin;
		now the first dummy is 0 minus total visibility;
		say " Low visibility (-", first dummy, " melee for anyone without low light vision or darkvision)[line break]";
	end if. [TODO]


Section - Enemy stats

Showing the enemy stats is an action out of world. Understand "enemies" and "estats" and "enemy" and "enemy stats" and "enemy statistics" as showing the enemy stats.

Carry out showing the enemy stats:
	say "[line break][bold type]Enemies:[roman type][line break]";
	repeat with enemy running through hostile alive monsters enclosed by the location begin;
		say "- [Enemy], [blood of enemy] out of [permanent blood of enemy] blood[line break]";
	end repeat. 



Section 2.0.0.1.6 - Action redirections

Instead of going down when the player is on a supporter: try exiting.




Chapter 2.0.0.2 - Monster Preliminaries


Section 2.0.0.2.1 - Hostility

A monster can be hostile, indifferent or friendly. A monster is usually hostile. [There are three kinds of monsters: hostile, indifferent and friendly. The first attack you; the second do nothing; the third help you. For now, I'll stick to implementing the first class.] [OK, I have implemented that all monsters become hostile once attacked.]

A preliminary results of attacking rule (this is the turn all indifferent monsters hostile rule):
	if the global defender is an indifferent monster begin; [This part ensures that indifferent monsters become hostile when attacked.]
		repeat with the former indifferent running through the indifferent monsters enclosed by the location begin;
			now the former indifferent is hostile;
		end repeat;
		now the noattack boolean is false;
	end if.


Section 2.0.0.2.2 - The senses

Instead of listening to a killed monster: say "Not even the beating of a heart.".

Instead of touching an alive monster: say "That is not an advisable combat move!"; take no time.

Instead of tasting an alive monster: say "That is not an advisable combat move!"; take no time.

Check touching a killed monster: 
	if a hostile alive monster is enclosed by the location begin;
		say "That can wait until you have disposed of your other enemies.";
		take no time;
	end if.

Check tasting a killed monster: 
	if an alive hostile monster is enclosed by the location begin;
		say "That can wait until you have disposed of your other enemies.";
		take no time;
	end if.
	

Section 2.0.0.2.3 - General responses

Check taking an alive monster: say "That doesn't sound like a very good move."; take no time instead.

Check taking a killed monster: say "You do not have a use for corpses."; take no time instead.



Section 2.0.0.2.4 - Level and significance

[Inform only has integers, so we are going to rescale monster level compared to player level. What we want is that a fight is standard if the added levels of the monsters are at least the level of the player; but to make more precise calculations possible, we will make this TEN TIMES the level of the player. So a monster with level 10 is significant on level 1.]

The initial combat significance is a number that varies. [This is calculated at the start of a combat, and will be used to see what the Gods think of you afterward.] The combat significance is a number that varies.

To calculate the initial combat significance:
	calculate the combat significance;
	now the initial combat significance is the combat significance.
	[say "Initial combat significance calculated at: ", initial combat significance.]

To calculate the combat significance:
	now the combat significance is 0; now the first dummy is 0; now the second dummy is 0;
	repeat with the opponent running through hostile alive monsters enclosed by the location begin;
		now the first dummy is the level of the opponent times the blood of the opponent;
		now the first dummy is the first dummy divided by the permanent blood of the opponent;
		increase the second dummy by the first dummy;
	end repeat;
	if the second dummy is greater than 5 times the level of the player, now the combat significance is 1;
	if the second dummy is greater than 9 times the level of the player, now the combat significance is 2;
	if the second dummy is greater than 15 times the level of the player, now the combat significance is 3;
	if the second dummy is greater than 20 times the level of the player, now the combat significance is 4.  

[So: if the combat significance is 0, you are almost guaranteed to win. If it is 2, it's interesting. If it's 4, it would be almost amazing if you win.]


Section 2.0.0.2.5 - Flavour text

[Flavour text describes the battles.]

A person has a table-name called the player flavour texts. The player flavour texts of a person is usually the table of generic player flavour texts.

A person has a table-name called the monster flavour texts. The monster flavour texts of a person is usually the table of generic monster flavour texts.


Table 2.0.0.2.5.1 - Generic Player Flavour Texts
Fatal Text			Hit Text			Miss Text			Absorbed Text				
"Swinging your sword, you aim for the head of [the global defender]. You put the sword in through the [one of]left[or]right[purely at random] eye, all the way down into the brain!"		"Swinging your sword, you aim for the head of [the global defender]. The sharp edge makes a bloody gash right across [possessive of the global defender] face."	"Swinging your sword, you aim for the head of [the global defender]. Your target ducks at the right moment, and your swing goes wide."		"Swinging your sword, you aim for the head of [the global defender]. You hit, but inflict only a scratch."
"You scream a foul oath as you attack, and with a mighty blow you open your opponent's arteries. Blood spurts everywhere around you!"		"You scream a foul oath as you attack, and manage to land a solid blow."		"You scream a foul oath as you attack, and miss. [The global defender] is not impressed."	"You scream a foul oath as you attack, and manage to hit [the global defender]. However, the force of the blow is too little to do any damage."
"Swinging your sword, you aim for the legs of [the global defender]. You chop right through the bone! [The global defender] falls down, and you finish it off with a couple of quick thrusts."		"Swinging your sword, you aim for the legs of [the global defender]. The sharp edge bites deep into the flesh."		"Swinging your sword, you aim for the legs of [the global defender]. Your target jumps at the right moment, evading your swing."	"Swinging your sword, you aim for the legs of [the global defender]. You manage to scratch the skin, but no more than that."


Table 2.0.0.2.5.1 - Generic Monster Flavour Texts
Fatal Text					Hit Text			Miss Text					Absorbed Text				
"[The global attacker] aims for your groin, and hits you with a fatal blow. Your intestines rip apart under the force. After several minutes of intense agony, you die."		"[The global attacker] aims for your groin, hitting you. You stumble back under the force of the blow."	"[The global attacker] aims for your groin, but you step aside easily."	"[The global attacker] aims for your groin, hitting you. Fortunately, your hard muscles absorb the weak blow."
"With a sudden rush, [the global attacker] attacks you. You fall backwards under the force of the onslaught, and within seconds, [the global attacker] is upon you and opens your jugular vein. You die in a pool of your own blood."		"With a sudden rush, [the global attacker] attacks you. Your ineffectual defence cannot stop the attack."		"With a sudden rush, [the global attacker] attacks you.  You sidestep easily, avoiding the blow."	"With a sudden rush, [the global attacker] attacks you. It is more show than substance, and he fails to do any real damage."
"[The global attacker] aims for your legs, and hits you with a bone-smashing blow! You fall down, unable to defend yourself, and are killed seconds later."		"[The global attacker] aims for your legs, hitting your [one of]left[or]right[purely at random] one. Luckily, you manage to remain upright."	"[The global attacker] aims for your legs, but you jump aside with a laugh."	"[The global attacker] aims for your legs, hits, but inflicts no worse than a bruise."


Section 2.0.0.2.6 - Grouping



	
After printing the name of a killed monster while not grouping together:
	if the global flavour text boolean is true, stop;
	if the monster is killed, say " (killed)".

After printing the plural name of a killed monster while not grouping together:
	if the global flavour text boolean is true, stop;
	if the monster is killed, say " (killed)".

After printing the name of an alive monster while asking which do you mean:
	if the global flavour text boolean is true, stop;
	if the monster is killed, say " (alive)".

[This stuff contributed by Mike Tarbert]


To decide what list of lists of objects is the (o-list - a list of 
objects) grouped by kind: 
        	let grouped-list be a list of lists of objects;  
        	while the number of entries in o-list is greater than 0:
		let test-obj be entry 1 in o-list;
		let sub-list be the entries of o-list sharing kind with the test-obj;
		add sub-list to grouped-list;
		remove sub-list from o-list;
		truncate sub-list to 0 entries;
	decide on grouped-list. 

To decide if (x - an object) is the same kind as (y - an object):
(- ({x}.i7_kind()=={y}.i7_kind()) -).

To decide what list of objects is the entries of (o-list - a list of objects) sharing kind with the (o - an object):
	let sub-list be a list of objects;
	repeat with item running through the o-list: 
		if item is the same kind as o, add item to sub-list;
	decide on sub-list.

To say (group - a list of objects) detailing (desc - a description) as (t - a text):
	let n be the number of entries in group;
	if n is one:
		say "[group with indefinite articles]";
	otherwise:
		say "[n in words] [the printed plural name of entry 1 in group]";
		let d be the number of desc listed in the group;
		if d is n:
			if d is 2, say " (both [t])";
			otherwise say " (all [t])";
		otherwise if d is one:
			say " (one of which is [t])";
		otherwise if d is greater than one:
			say " ([d in words] of which are [t])".

To decide what number is the number of (d - a description) listed in the (o-list - a list of objects):
	let l be the list of d listed in the o-list;
	let n be the number of entries in l;
	decide on n.

[create sub-list based on description]
To decide what list of objects is the list of (d - a description) listed in the (o-list - a list of objects):
	let sub-list be a list of objects;
	repeat with item running through o-list:
		if item is listed in the list of d, add item to sub-list;
	decide on sub-list.

To say (g-list - a list of lists of objects) detailing (desc - a description) as (t - a text):
	let n be the number of entries in g-list;
	let g be 1;
	repeat with group running through g-list:
		say group detailing desc as t;
		if g is n:
			say ".";
		otherwise if g is n - 1:
			say " and ";
		otherwise:
			say ", ";
		let g be g + 1.

[Put it in practice]

Rule for writing a paragraph about a monster: 
	if the number of monsters in the location is greater than one:
		say "You can see ";
		let monster-list be the list of monsters in the location grouped by kind;
		say monster-list detailing killed monsters as "killed";
		now every monster in the location is mentioned.



Book 2.1 - Monster Skills


Chapter 2.1.0.1 - Regeneration 

[Regeneration means that the monster will get regeneration rate blood back every turn. Note 1: this only happens when the monster is alive. Note 2: the maximum blood remains the permanent blood. Note 3: the player should try to maximise damage against such monsters; even deadlier combat becomes a viable tactical option.]


A monster is either regenerating or not regenerating. A monster is usually not regenerating.

A monster has a number called the regeneration rate. The regeneration rate of a monster is usually 0. 

Every turn:
	repeat with the patient running through alive regenerating monsters begin;
		if the blood of the patient is less than the permanent blood of the patient begin;
			increase the blood of the patient by the regeneration rate of the patient;
			if the blood of the patient is greater than the permanent blood of the patient, now the blood of the patient is the permanent blood of the patient; 
		end if;
	end repeat. 



Chapter 2.1.0.2 - Poisonous

A person can be poisonous or not poisonous. A person is usually not poisonous.

A person has a number called the poison chance. The poison chance of a person is usually 0.
A person has a number called the minimum poison damage. The minimum poison damage is usually 0.
A person has a number called the maximum poison damage. The maximum poison damage is usually 0.
A person has a number called the poison time. The poison time is usually 0.

[If bitten by a poisonous monster, you must first roll against the poison chance. If you do not beat the number, you are poisoned. You will then get a random amount between minimum and maximum damage every turn for poison time turns.]

[We are going to use these same numbers for the player!]

Every turn when the player is poisonous:
	decrease the poison time of the player by 1;
	now the first dummy is a random number between the minimum poison damage of the player and the maximum poison damage of the player;
	say "The [bold type]poison[roman type] in your blood deals you ", first dummy, " damage!";
	deal first dummy damage to the player;
	if the poison time of the player is 0, now the player is not poisonous.
	
[And to get him poisoned]

To have (the attacker - a person) poison (the defender - a person):
	now the first dummy is a random number between 1 and 6;
	say " [italic type](You roll ", first dummy, " against a poison chance of ", poison chance of the attacker;
	if the first dummy is greater than the poison chance of the attacker begin;
		say ", [bold type]resisting the poison[roman type] of [the attacker]!)[roman type]";
		continue the activity;
	end if;
	say ". You are [bold type]poisoned[italic type]!)[roman type]";
	now the minimum poison damage of the defender is the minimum poison damage of the attacker;
	now the maximum poison damage of the defender is the maximum poison damage of the attacker;
	now the poison time of the defender is the poison time of the attacker;
	now the defender is poisonous.
	

Chapter 2.1.0.3 - Special damage

A person has a number called the damage die. The damage die of a person is usually 6.

A person has a number called the damage bonus. The damage bonus of a person is usually 0.


Chapter 2.1.0.4 - Holding on

A person can be an onholder or not an onholder. A person is usually not an onholder.

A person is either a legholder or not a legholder. A person is usually not a legholder.

A person has a number called the hold chance. The hold chance of a person is usually 4.
A person has a number called the hold damage. The hold damage of a person is usually 1.
A person has a number called the hold leg melee penalty. The hold leg melee penalty of a person is usually 0.
A person has a number called the hold leg defence penalty. The hold leg defence penalty of a person is usually 1.
A person has a number called the hold arm melee penalty. The hold arm melee penalty of a person is usually 1.
A person has a number called the hold arm defence penalty. The hold arm defence penalty of a person is usually 0.
A person has a number called the hold release. The hold release of a person is usually 3.
A person has a number called the hold self defence penalty. The hold self defence penalty of a person is usually 1.

A person has a number called the hold location. The hold location of a person is usually 0. [0 is none. 1 is leg. 2 is arm.] 

[How does this work? When an onholder hits, he has a chance equal to the hold chance / 6 to hold on to the player; either onto his leg or onto his arm. Now, he will hold on until dealt at least hold release damage in a single turn, or killed. Every turn, he will deal hold damage damage. He will also give a melee and defence penalty to the player, depending on whether he holds on to the leg or the arm. The onholder has a defence penalty of hold self defence penalty as long as he holds on. A legholder always holds on to your leg.]

Every turn when a killed onholder monster is enclosed by the location:
	repeat with opponent running through the killed onholder monsters enclosed by the location begin;
		now the hold location of the opponent is 0;
	end repeat.  


To have (the attacker - a person) hold on to (the defender - a person):
	if the player is alive begin;
		now the first dummy is a random number between 1 and 6;
		say " ([The attacker] rolls ", first dummy, " against a hold chance of ", hold chance of the attacker;	
		if the first dummy is less than the hold chance of the attacker begin;
			say ", failing to hold on to you!)[run paragraph on]";
			continue the activity;
		end if;
		now the hold location of the attacker is a random number between 1 and 2;
		if the attacker is a legholder, now the hold location of the attacker is 1;
		if the hold location of the attacker is 1, say ", grabbing your leg and not intending to let go!)[run paragraph on]";
		if the hold location of the attacker is 2, say ", grabbing your arm and not intending to let go!)[run paragraph on]";
	end if.

To have (the attacker - a person) deal hold damage to (the defender - a person):
	now the first dummy is the hold damage of the attacker;
	say "While firmly holding on to your ";
	if the hold location of the attacker is 1, say "leg";
	if the hold location of the attacker is 2, say "arm";
	say ", [the attacker] deals ", first dummy, " damage![run paragraph on]";
	deal first dummy damage to the defender;
	if the attacker is on fire begin;
		if the defender is not on fire begin;
			if a random chance of 1 in 2 succeeds begin;
				now the printing state is printing-fiery;
				say " In addition, you are set ablaze![run paragraph on]";
				now the printing state is printing-normal;
				set fire to the defender;
			end if;
		end if;
	otherwise if the defender is on fire;
		if a random chance of 1 in 2 succeeds begin;
			now the printing state is printing-fiery;
			say " [The attacker] is enveloped by the flames that surround you![run paragraph on]";
			now the printing state is printing-normal;
			set fire to the attacker;
		end if;
	end if;
	say "[paragraph break]".


An attack modifiers rule (this is the onholder attack penalty or bonus rule):
	if the global attacker is the player begin;
		repeat with the opponent running through hostile alive onholder monsters enclosed by the location begin;
			if the hold location of the opponent is 1 begin;
				decrease the to-hit modifier by the hold leg melee penalty of the opponent;
				if the hold leg melee penalty of the opponent is not 0, say " - ", hold leg melee penalty of the opponent, " ([the opponent] holding on to your leg)";
			end if;
			if the hold location of the opponent is 2 begin;
				decrease the to-hit modifier by the hold arm melee penalty of the opponent;
				if the hold arm melee penalty of the opponent is not 0, say " - ", hold arm melee penalty of the opponent, " ([the opponent] holding on to your arm)";
			end if;
		end repeat;
	end if;
	if the global defender is the player begin;
		repeat with the opponent running through hostile alive onholder monsters enclosed by the location begin;
			if the hold location of the opponent is 1 begin;
				increase the to-hit modifier by the hold leg defence penalty of the opponent;
				if the hold leg defence penalty of the opponent is not 0, say " + ", hold leg defence penalty of the opponent, " ([the opponent] holding on to your leg)";
			end if;
			if the hold location of the opponent is 2 begin;
				increase the to-hit modifier by the hold arm defence penalty of the opponent;
				if the hold arm defence penalty of the opponent is not 0, say " + ", hold arm defence penalty of the opponent, " ([the opponent] holding on to your arm)";
			end if;
		end repeat;
	end if;


An always-present attack modifiers rule (this is the an onholder gets a defence penalty rule):
	if the global defender is onholder begin; [Defender is holding on]
		if the hold location of the global defender is not 0 begin;
			say " + ", the hold self defence penalty of the global defender, " (defender holding on)[run paragraph on]";
			increase the to-hit modifier by the hold self defence penalty of the global defender; 
		end if;
	end if.


Chapter 2.1.0.5 - Damage reduction

A person has a number called damage reduction. The damage reduction of a person is usually 0.


Chapter 2.1.0.6 - Erratic attacker

A person is either an erratic attacker or not an erratic attacker. A person is usually not an erratic attacker.

[An erratic attacker only attacks sometimes.]

A person has a number called the erratic attack odds. The erratic attack odds of a person are usually 6. [6 in 6, that is.]
A person has a text called the erratic attack failure text. The erratic attack failure text of a person is usually "".


Chapter 2.1.0.7 - Fireproof

A person is either fireproof or not fireproof. A person is usually not fireproof.


Chapter 2.1.0.8 - Summoned

A monster is either summoned or not summoned. A monster is usually not summoned.


Chapter 2.1.0.9 - Vampiric

A monster is either vampiric or not vampiric. A monster is usually not vampiric.

A monster has a number called the vampire ratio. The vampire ratio of a monster is usually 5. [Read this as 5 in 10. Whenever the vampiric monster deals X damage, it gets X * vampire ratio / 10 blood, up to its maximum.]

To do sucking blood with (the attacker - a person) and (the defender - a person):
	now the second dummy is the permanent blood of the attacker minus the blood of the attacker;
	if the second dummy is not 0 begin;
		now the first dummy is the final damage;
		now the first dummy is the first dummy times the vampire ratio of the attacker;
		now the first dummy is the first dummy divided by 10;
		if the first dummy is greater than the second dummy, now the first dummy is the second dummy;
		if the first dummy is not 0 begin;
			increase the blood of the attacker by the first dummy;
	 		say " [italic type]Drinking deeply from [possessive of the defender] blood, [the attacker] regains ", first dummy, " blood![roman type]";
		end if;
	end if.


Chapter 2.1.0.10 - Boss

A monster is either boss or not boss. A monster is usually not boss. [We don't print fatal flavour text for boss creatures. The writer must implement something himself. I use this for fatalities and for people who need to give a dramatic farewell speech.]


Chapter 2.1.0.11 - Non-exciting

A monster can be non-exciting. A monster is usually not non-exciting.

[Non-exciting monsters, such as straw man, don't raise excitement when hitting or being hit.]



Book 2.2 - Monster Definitions


Part 2.2.1 - Animals


Chapter 2.2.1.1 - Wild Boar

A wild boar is a kind of monster.
Understand "pig" and "tusk" and "tusks" as a wild boar.

[The senses]

Instead of examining a wild boar: say "Essentially a very large pig, but much more ferocious and equipped with two large tusks."

Instead of smelling a wild boar: say "A strong smell of musk emanates from the animal.".

Instead of listening to an alive wild boar: say "It sounds quite angry."

Instead of touching a killed wild boar: say "Its rough hair is surprisingly soft to the touch.".

Instead of tasting a killed wild boar: say "When roasted, wild boar makes an excellent dish. But you are not here to cook the Deathlord a meal.".


[The numbers]

The blood of a wild boar is usually 10.
The zeal of a wild boar is usually 0.
The melee of a wild boar is usually 1.
The mind of a wild boar is usually 0.
The defence of a wild boar is usually 2. 

The level of a wild boar is usually 10.


[The tables]

The player flavour texts of a wild boar is usually the Table of Wild Boar Player Flavour Texts.
The monster flavour texts of a wild boar is usually the Table of Wild Boar Monster Flavour Texts.


Table of Wild Boar Player Flavour Texts
Fatal Text			Hit Text			Miss Text			Absorbed Text				
"With a masterful stroke, you bury your blade in [possessive of the global defender] brain, killing him instantly."	"Evading the large tusks, you manage to land a solid blow on [possessive of the global defender] [one of]left[or]right[at random] flank."	"You move in to plant your blade in [possessive of the global defender] head, but a violent counterattack with his tusks leaves you on the defence."	"With a deft maneuver you manage to hit [the global defender], but your sword doesn't so much as draw blood."
"Swinging your sword, you aim for the head of [the global defender]. You put the sword in through the [one of]left[or]right[purely at random] eye, all the way down into the brain!"		"Swinging your sword, you aim for the head of [the global defender]. The sharp edge makes a bloody gash right across [possessive of the global defender] face."	"Swinging your sword, you aim for the head of [the global defender]. Your target backs away at the right moment, and your swing goes wide."		"Swinging your sword, you aim for the head of [the global defender]. You hit, but inflict only a scratch."
"You scream a foul oath as you attack, and with a mighty blow you open your opponent's arteries. Blood spurts everywhere around you!"		"You scream a foul oath as you attack, and manage to land a solid blow."		"You scream a foul oath as you attack, and miss. [The global defender] is not impressed."	"You scream a foul oath as you attack, and manage to hit [the global defender]. However, the force of the blow is too little to do any damage."


Table of Wild Boar Monster Flavour Texts
Fatal Text					Hit Text			Miss Text					Absorbed Text				
"[The global attacker] rips open your groin with his huge tusks. Your innards fall out, and after several minutes of intense agony, you die."		"[The global attacker] aims for your groin, hitting you with one of his sharp tusks. You stumble back under the force of the blow."	"[The global attacker] aims for your groin, but you step aside easily."	"[The global attacker] aims for your groin, hitting you with one of his sharp tusks. Fortunately, your hard muscles absorb the weak blow."
"With a sudden rush, [the global attacker] attacks you. You fall backwards under the force of the onslaught, and within seconds, [the global attacker] is upon you. You are trampled and ripped apart, and die in a pool of your own blood."		"With a sudden rush, [the global attacker] attacks you. Your ineffectual defence cannot stop the attack, and you receive a big gash along your [one of]left[or]right[purely at random] leg."		"With a sudden rush, [the global attacker] attacks you.  You sidestep easily, avoiding the blow."	"With a sudden rush, [the global attacker] attacks you--but his tusks, fearsome as they look, leave you unharmed."
"[The global attacker] charges you and hits your legs with his full weight! You fall down, and are killed within seconds."		"[The global attacker] charges you, hitting your [one of]left[or]right[purely at random] leg. Luckily, you manage to remain upright."	"[The global attacker] charges you, but you jump aside with a laugh."	"[The global attacker] charges and even hits you, but inflicts no worse than a bruise."


Chapter 2.2.1.2 - Young Boar

A young boar is a kind of monster.
Understand "pig" and "tusk" and "tusks" as a young boar.

[The senses]

Instead of examining a young boar: say "Essentially a very large pig, but much more ferocious and equipped with two large tusks."

Instead of smelling a young boar: say "A strong smell of musk emanates from the animal.".

Instead of listening to an alive young boar: say "It sounds quite angry."

Instead of touching a killed young boar: say "Its rough hair is surprisingly soft to the touch.".

Instead of tasting a killed young boar: say "When roasted, young boar makes an excellent dish. But you are not here to cook the Deathlord a meal.".


[The numbers]

The blood of a young boar is usually 6.
The zeal of a young boar is usually 0.
The melee of a young boar is usually 1.
The mind of a young boar is usually 0.
The defence of a young boar is usually 1. 

The level of a young boar is usually 6.


[The tables]

The player flavour texts of a young boar is usually the Table of Wild boar Player Flavour Texts.
The monster flavour texts of a young boar is usually the Table of Wild boar Monster Flavour Texts.



Chapter 2.2.1.2 - Dog

A dog is a kind of monster.

[The senses]

Instead of examining a dog: say "Dogs come in many sizes and colours. This particular one is of no recognisable breed. It comes almost to your waist, is the colour of ashes, and seems quite ferocious."

Instead of smelling a dog: say "The slightly unpleasant smell of dog.".

Instead of listening to an alive dog: say "It barks at you."

Instead of touching a killed dog: say "Soft and cooling rapidly.".

Instead of tasting a killed dog: say "Although there reputedly are parts of the world where people eat dogs, your village is not one of them.".


[The numbers]

The blood of a dog is usually 8.
The zeal of a dog is usually 0.
The melee of a dog is usually 1.
The mind of a dog is usually 0.
The defence of a dog is usually 3. 

The level of a dog is usually 7.

[The special]

The damage die of a dog is usually 4.

A dog is usually an onholder.

The hold chance of a dog is usually 5.
The hold damage of a dog is usually 1.
The hold leg melee penalty of a dog is usually 1.
The hold leg defence penalty of a dog is usually 1.
The hold arm melee penalty of a dog is usually 1.
The hold arm defence penalty of a dog is usually 1.
The hold release of a dog is usually 3.
The hold self defence penalty of a dog is usually 2.



[The tables]

The player flavour texts of a dog is usually the Table of Dog Player Flavour Texts.
The monster flavour texts of a dog is usually the Table of Dog Monster Flavour Texts.

Table of Dog Player Flavour Texts
Fatal Text			Hit Text			Miss Text			Absorbed Text
"A quick stroke, and you sever [possessive of the global defender] head from its neck. Blood sprays all over your chest."	"A big 'yelp', and fur is flying all around you!"	"The damned [global defender] is too quick, and your swing goes wide."	"Your blade collides with the chest of [the global defender], but does no obvious harm."
"With a masterful stroke, you bury your blade in [possessive of the global defender] brain, killing him instantly."	"Evading the slavering fangs, you manage to land a solid blow on [possessive of the global defender] [one of]left[or]right[at random] flank."	"You move in to plant your blade in [possessive of the global defender] head, but a violent counterattack leaves you on the defence."	"With a deft maneuver you manage to hit [the global defender], but your sword doesn't so much as draw blood."
"Swinging your sword, you aim for the legs of [the global defender]. You chop right through the bone! [The global defender] falls down, and you finish it off with a couple of quick thrusts."		"Swinging your sword, you aim for the legs of [the global defender]. The sharp edge bites deep into the flesh."		"Swinging your sword, you aim for the legs of [the global defender]. Your target jumps at the right moment, evading your swing."	"Swinging your sword, you aim for the legs of [the global defender]. You manage to scratch the skin, but no more than that."

Table of Dog Monster Flavour Texts
Fatal Text			Hit Text			Miss Text			Absorbed Text
"'All is lost!', you realise as [possessive of the global attacker] fangs close in on your throat."	"You try to duck away as [the global attacker] attacks you, but it is too late. Big teeth and powerful jaws painfully tear at your flesh."	"[The global attacker] goes for your throat, but a backhanded blow with the hilt of your sword persuades it of its mistake."	"Teeth close in on your flesh, but it turns out that you are not an easy prey."
"[The global attacker] goes for your throat, and manages to rip open your jugular vein! With your lifeblood pumping out of you in big gushes, your fate is sealed."	"[The global attacker] evades your swings and sinks its teeth into your body."	"You give a good kick to [the global attacker] as it attempts to hurt you."	"A puzzled expression appears on [possessive of the global attacker] snout when it fails to do any damage to you."
"With a sudden rush, [the global attacker] attacks you. You fall backwards under the force of the onslaught, and within seconds, [the global attacker] is upon you and opens your jugular vein. You die in a pool of your own blood."		"With a sudden rush, [the global attacker] attacks you. Your ineffectual defence cannot stop the attack."		"With a sudden rush, [the global attacker] attacks you.  You sidestep easily, avoiding the blow."	"With a sudden rush, [the global attacker] attacks you. It is more show than substance, and he fails to do any real damage."


Section 2.2.1.2.1 - Doberman

A doberman is a kind of dog.

Instead of examining a doberman: say "A very large dog, black on the upper and brown of the lower side of its body. Its cropped ears are raised menacingly, and its bite is worse than its bark.".

[Numerical differences with other dogs]



Section 2.2.1.2.2 - Pit-bull

A pit-bull is a kind of dog.

Instead of examining a pit-bull: say "Big jaws on legs, the pit-bull is a ferocious fighting dog. Once it grabs hold of someone, it does not let go.".

[Numerical differences with other dogs]

The hold chance of a pit-bull is usually 3. The hold damage of a pit-bull is usually 2. The hold release of a pit-bull is usually 6. The level of a pit-bull is usually 8.



Section 2.2.1.2.3 - Terrier

A terrier is a kind of dog.

Instead of examining a terrier: say "The Jack Russell terrier is a small dog, but much faster than its short legs may suggest. It is white with brown spots.".

[Numerical differences with other dogs]

A terrier is usually a legholder.
A terrier is usually fast.
The damage die of a terrier is usually 3.
The hold leg defence penalty of a terrier is usually 0.
The defence of a terrier is usually 4.
The blood of a terrier is usually 7.



Section 2.2.1.2.4 - Bouvier

A bouvier is a kind of dog.

Instead of examining a bouvier: say "The bouvier is a large black dog, with curious guarding behaviour. It will always allow you to enter its domain without attacking you; but it will not allow you to leave.".

[Numerical differences with other dogs]

A bouvier is usually indifferent.
A bouvier is usually fast.

Instead of going or retreating when an alive indifferent bouvier is enclosed by the location:
	if exactly one alive indifferent bouvier is enclosed by the location begin;
		say "The bouvier suddenly growls menacingly and moves to block your way.";
	otherwise;
		say "The bouviers growl menacingly and move to block your way.";
	end if.



Section 2.2.1.2.5 - German shepherd

A German shepherd is a kind of dog.

Instead of examining a German shepherd: say "The German shepherd is a large black-and-brown dog, originally used for herding sheep but also very effective as a guard dog. It looks very tough.".

[Numerical differences with other dogs]

The blood of a German shepherd is usually 9.
The hold chance of a German shepherd is usually 6.


Section 2.2.1.2.6 - Rhodesian Ridgeback

A Rhodesian Ridgeback is a kind of dog.

Instead of examining a Rhodesian Ridgeback: say "The Rhodesian Ridgeback is a huge brown dog. It gets its name from the characteristic ridge of hair on its back, which gives it an appropriately aggressive look.".

[Numerical differences with other dogs]

The blood of a Rhodesian Ridgeback is usually 10.
The damage die of a Rhodesian Ridgeback is usually 5.
The hold arm melee penalty of a Rhodesian Ridgeback is usually 2.
The hold arm defence penalty of a Rhodesian Ridgeback is usually 2.
The level of a Rhodesian Ridgeback is usually 9.



Chapter 2.2.1.3 - Snake


A snake is a kind of monster.

[The senses]

Instead of examining a snake: say "As long as your forearm, this reptile is well-known for being poisonous. Two sharp teeth protrude from its upper jaw, and a forked tongue flicks and out of its mouth, scenting you."

Instead of smelling a snake: say "The snake has no discernible smell.".

Instead of listening to an alive snake: say "It hisses softly."

Instead of touching a killed snake: say "Scaly, and cold to the touch.".

Instead of tasting a killed snake: say "The meat might be poisonous.".


[The numbers]

The blood of a snake is usually 5.
The zeal of a snake is usually 0.
The melee of a snake is usually 0.
The mind of a snake is usually 0.
The defence of a snake is usually 2.

The level of a snake is usually 4.


[The special]

The damage die of a snake is usually 4.

A snake is usually poisonous.

The poison chance of a snake is usually 1.
The minimum poison damage of a snake is usually 0.
The maximum poison damage of a snake is usually 1.
The poison time of a snake is usually 3.



Chapter 2.2.1.4 - Mud Crab

A mud crab is a kind of monster.


[The senses]

Instead of examining a mud crab: say "A medium-sized crab, not much bigger than hand."

Instead of smelling a mud crab: say "It smells of the swamp.".

Instead of listening to an alive mud crab: say "It shears clack together with a soft clicking sound."

Instead of touching a killed mud crab: say "Hard, cold, slick.".

Instead of tasting a killed mud crab: say "This might not be the time for sea fruit, or for swamp fruit either.".


[The numbers]

The blood of a mud crab is usually 5.
The zeal of a mud crab is usually 0.
The melee of a mud crab is usually 1.
The mind of a mud crab is usually 0.
The defence of a mud crab is usually 4. 

The level of a mud crab is usually 4.

The damage die of a mud crab is usually 3.

[The special]

A mud crab is usually fireproof.

The damage reduction of a mud crab is usually 3.

A mud crab is usually lowlightvisioned.


Chapter 2.2.1.5 - Bat

A bat is a kind of monster.


[The numbers]

The blood of a bat is usually 6.
The zeal of a bat is usually 0.
The melee of a bat is usually 1.
The mind of a bat is usually 0.
The defence of a bat is usually 6.

The level of a bat is usually 3.

The damage die of a bat is usually 2.


[The special]

A bat is usually darkvisioned.


[The tables]

The player flavour texts of a bat is usually the Table of Bat Player Flavour Texts.
The monster flavour texts of a bat is usually the Table of Bat Monster Flavour Texts.

Table of Bat Player Flavour Texts
Fatal Text			Hit Text			Miss Text			Absorbed Text
"You wait until [the global defender] flies towards you, then suddenly raise your sword. The bat doesn't see it coming and impales itself upon your blade!"	"You manage to cut off part of [possessive of the global defender] [one of]left[or]right[purely at random] wing, but it's not enough to bring it down."	"The point of your blade almost hits [the global defender], but it flits out of the way just in time."	"You hit [the global defender] but do no real damage."
"Two fast cuts and [the global defender] loses both its wing, falling helplessly on the ground. You take great pleasure in crushing its head under the heel of your boot."	"You give [the global defender] a serious whack on its little head."	"[The global defender] flutters all about you, and however hard you try, you can't seem to hit it."	"Your blow hits, but merely knocks [the global defender] back."
"You wonder if bats have an ultrasonic death shriek--it's a pity you wouldn't be able to hear it if they did. Anyway, this sucker is down, and it's not getting up again."	"The flat of your blade knocks [the global defender] to the other side of the room."	"Damn those fast wings! Your swing goes wide again."	"With a deft maneuver you manage to hit [the global defender], but your sword doesn't so much as draw blood."

Table of Bat Monster Flavour Texts
Fatal Text			Hit Text			Miss Text			Absorbed Text
"You shriek and shriek as [the global attacker] sets its sharp little teeth in your eyes, and beats its wings against your ears--but you were already weakened, and your life flows away with the screams."	"[The global attacker] dives for your head. You try to duck away, but it is faster than you."	"You manage to keep [the global attacker] at bay with your sword."	"[Possessive of the global attacker] teeth are small and can't hurt you."
"You shriek and shriek as [the global attacker] sets its sharp little teeth in your eyes, and beats its wings against your ears--but you were already weakened, and your life flows away with the screams."	"You feel the sharp teeth of [the global attacker] sinking into your neck."	"You punch [the global attacker] away before it can bite you."	"You laugh at [the global attacker] as it attempts to bite through your armour."
"What could a bat do to you? Yet--suddenly you stumble, and you realise that you've lost much blood. Too much blood. You stumble again; you fall; everything blacks out."	"Furiously beating its wings and displaying its sharp teeth, the bat penetrates your defences and your skin!"	"You duck away, and [the global attacker] flies by."	"You laugh at [the global attacker] as it attempts to bite through your armour."



Chapter 2.2.1.6 - Scorpion

A scorpion is a kind of monster.

[The numbers]

The blood of a scorpion is usually 5.
The zeal of a scorpion is usually 0.
The melee of a scorpion is usually 0.
The mind of a scorpion is usually 0.
The defence of a scorpion is usually 2.

The level of a scorpion is usually 5.


[The special]

The damage die of a scorpion is usually 2.

A scorpion is usually poisonous.

The poison chance of a scorpion is usually 3.
The minimum poison damage of a scorpion is usually 0.
The maximum poison damage of a scorpion is usually 2.
The poison time of a scorpion is usually 3.

A scorpion is usually fireproof.

The damage reduction of a scorpion is usually 1.

A scorpion is usually darkvisioned.


Part 2.2.2 - Animal-like monstrous creatures




Chapter 2.2.2.1 - Water Serpent

A water serpent is a kind of monster.


[The senses]

Instead of examining a water serpent: say "A monstrous beast, as thick as your waist and easily thrice your length. Two sharp teeth protrude from its upper jaw, and a forked tongue flicks and out of its mouth, scenting you."

Instead of smelling a water serpent: say "The serpent smells slightly of fish.".

Instead of listening to an alive water serpent: say "Its hissing is hardly to be heard above the sounds of splashing water."

Instead of touching a killed water serpent: say "Scaly and wet, like a fish.".

Instead of tasting a killed water serpent: say "The meat might be poisonous.".


[The numbers]

The blood of a water serpent is usually 10.
The zeal of a water serpent is usually 0.
The melee of a water serpent is usually 1.
The mind of a water serpent is usually 0.
The defence of a water serpent is usually 3. 

The level of a water serpent is usually 15.


[The special]

A water serpent is usually poisonous.

The poison chance of a water serpent is usually 2.
The minimum poison damage of a water serpent is usually 0.
The maximum poison damage of a water serpent is usually 1.
The poison time of a water serpent is usually 4.



Chapter 2.2.2.2 - Giant Mud Crab

A giant mud crab is a kind of monster.


[The senses]

Instead of examining a giant mud crab: say "A crab-like creature the size of a cow, with big shears that look as it they could easily crack a woman's skull. Its thick carapace seems nigh impenetrable."

Instead of smelling a giant mud crab: say "It smells of the swamp.".

Instead of listening to an alive giant mud crab: say "It shears clack together with the sound of brick on brick."

Instead of touching a killed giant mud crab: say "Hard, cold, slick.".

Instead of tasting a killed giant mud crab: say "This might not be the time for sea fruit, or for swamp fruit either.".


[The numbers]

The blood of a giant mud crab is usually 16.
The zeal of a giant mud crab is usually 0.
The melee of a giant mud crab is usually -1.
The mind of a giant mud crab is usually 0.
The defence of a giant mud crab is usually 4. 

The level of a giant mud crab is usually 14.

The damage die of a giant mud crab is usually 10.

[The special]

A giant mud crab is usually slow.

A giant mud crab is usually fireproof.

The damage reduction of a giant mud crab is usually 10.

A giant mud crab is usually an erratic attacker.
The erratic attack odds of a giant mud crab is usually 2.
The erratic attack failure text of a giant mud crab is usually "The giant mud crab [one of]lumbers forward[or]attempts to turn its huge body in your direction[or]raises its giant shears for its attack[at random][one of], while its stick-supported eyes flawlessly track your position[or], accompanied by the harsh clicking of its six hind legs[or][at random].[paragraph break]".

A giant mud crab is usually lowlightvisioned.



Chapter 2.2.2.3 - Vampire bat

A vampire bat is a kind of monster.


[The numbers]

The blood of a vampire bat is usually 5.
The zeal of a vampire bat is usually 0.
The melee of a vampire bat is usually 2.
The mind of a vampire bat is usually 0.
The defence of a vampire bat is usually 2.

The level of a vampire bat is usually 8.

The damage die of a vampire bat is usually 3.


[The special]

A vampire bat is usually vampiric.

The vampire ratio of a vampire bat is usually 8.

A vampire bat is usually darkvisioned.

[The tables]

The player flavour texts of a vampire bat is usually the Table of Bat Player Flavour Texts.
The monster flavour texts of a vampire bat is usually the Table of Bat Monster Flavour Texts.


Chapter 2.2.2.4 - Monstrous scorpion


A monstrous scorpion is a kind of monster.

[The numbers]

The blood of a monstrous scorpion is usually 12.
The zeal of a monstrous scorpion is usually 0.
The melee of a monstrous scorpion is usually 1.
The mind of a monstrous scorpion is usually 0.
The defence of a monstrous scorpion is usually 2.

The level of a monstrous scorpion is usually 16.


[The special]

The damage die of a monstrous scorpion is usually 4.

A monstrous scorpion is usually poisonous.

The poison chance of a monstrous scorpion is usually 4.
The minimum poison damage of a monstrous scorpion is usually 1.
The maximum poison damage of a monstrous scorpion is usually 4.
The poison time of a monstrous scorpion is usually 4.

A monstrous scorpion is usually fireproof.

The damage reduction of a monstrous scorpion is usually 3.

A monstrous scorpion is usually darkvisioned.




Part 2.2.3 - Humans

Chapter 2.2.3.1 - Guards

Section 2.2.3.1.1 - Normal guards

A guarder is a kind of monster.

The blood of a guarder is usually 8.
The zeal of a guarder is usually 0.
The melee of a guarder is usually 1.
The mind of a guarder is usually 0.
The defence of a guarder is usually 2. 

The level of a guarder is usually 10.

[The specials]

The damage reduction of a guarder is usually 1.




Part 2.2.4 - Human-like monstrous creatures


Chapter 2.2.4.1 - Trolls


Section 2.2.4.1.1 - Troll

A troll is a kind of monster.


[The senses]

Instead of examining a troll: say "This massive and foul-smelling creature, vaguely humanoid but completely covered in greasy black hair, might well outweigh a large bull. It is a troll, a creature of legendary cruelty, obscenely naked and quite as filthy as the legends describe.".

Instead of smelling a troll: say "The rank smells of old piss and rotting eggs waft from its body.".

Instead of listening to an alive troll: say "It grunts incessantly, except when it noisily blows its nose in the hair on its simian arms.".

Instead of touching a killed troll: say "Its hairy skin is covered with substances that appear to be snot, blood and shit. Nothing will make you touch that.".

Instead of tasting a killed troll: say "Its hairy skin is covered with substances that appear to be snot, blood and shit. Nothing will make you taste that.".


[The numbers]

The blood of a troll is usually 15.
The zeal of a troll is usually 0.
The melee of a troll is usually 1.
The mind of a troll is usually 0.
The defence of a troll is usually 3. 

The level of a troll is usually 20.

[The specials]

A troll is usually slow.


A troll is usually regenerating. The regeneration rate of a troll is 2.


Section 2.2.4.1.2 - Young Troll

A young troll is a kind of monster.


[The senses]

Instead of examining a young troll: say "This man-sized foul-smelling creature, vaguely humanoid but largely covered in greasy brown hair, is a young troll. Its cruel leer shows nothing of the innocence of childhood.".

Instead of smelling a young troll: say "The rank smells of piss and rotting eggs waft from its body.".

Instead of listening to an alive young troll: say "The young troll noisily smacks his mouth."

Instead of touching a killed young troll: say "Its hairy skin is covered with substances that appear to be snot, blood and shit. Nothing will make you touch that.".

Instead of tasting a killed young troll: say "Its hairy skin is covered with substances that appear to be snot, blood and shit. Nothing will make you taste that.".


[The numbers]

The blood of a young troll is usually 10.
The zeal of a young troll is usually 0.
The melee of a young troll is usually 1.
The mind of a young troll is usually 0.
The defence of a young troll is usually 3. 

The level of a young troll is usually 11.

[The specials]

A young troll is usually slow.

A young troll is usually regenerating. The regeneration rate of a young troll is 1.


Chapter 2.2.4.2 - Straw people

A straw being is a kind of monster.


[The senses]

Instead of examining a straw being: say "[The noun] is made completely of straw.".

Instead of smelling a straw being: say "The characteristic odour of slightly wet straw.". 

Instead of listening to an alive straw being: say "It is silent.".

Instead of touching a killed straw being: say "Smooth, yet prickly--straw."

Instead of tasting a killed straw being: say "That is not the edible part of grain.".

[The numbers]

The blood of a straw being is usually 10.
The zeal of a straw being is usually 0.
The melee of a straw being is usually 1.
The mind of a straw being is usually 99.
The defence of a straw being is usually 5. 

The level of a straw being is usually 1.

[The specials]

A straw being is usually slow.

A straw being is usually non-exciting.

A straw being is usually an erratic attacker.
The erratic attack odds of a straw being are usually 0.
The erratic attack failure text of a straw being is usually "[The global attacker] [one of]would have attacked you, had he been able to[or]just stands there[or]awaits your fury[at random].[paragraph break]".

The player flavour texts of a straw being is usually the Table of Straw Player Flavour Texts.
The monster flavour texts of a straw being is usually the Table of Straw Monster Flavour Texts.

Table of Straw Player Flavour Texts
Fatal Text			Hit Text			Miss Text			Absorbed Text
"You hit [the global defender] with a satisfying blow, and straw flies all around the room. That's one less thing in the world to bother you!"	"You land a solid blow against [the global defender]. Several pieces of straw come loose and fall to the ground."	"You manage to miss [the global defender]."	"The soft straw absorbs the impact of your blow."
"With a loud laugh you decapitate [the global defender], its straw-filled head rolling across the floor."	"You stick your sword into [the global defender]. It would have done more damage had there been any vital organs inside."	"With a loud *thunk* your sword hits the floor."	"The soft straw absorbs the impact of your blow."
"You hit [the global defender] with a satisfying blow, and straw flies all around the room. That's one less thing in the world to bother you!"	"[The global defender] appears to beg for mercy as your blade mercilessly hacks into the straw."	"Somehow, your blow misses [the global defender]."	"The soft straw absorbs the impact of your blow."

Table of Straw Monster Flavour Texts
Fatal Text			Hit Text			Miss Text			Absorbed Text
"Congratulations. You were killed by a being made of straw. Please do not expect me to write a serious message about how it smothered you with its evil straw-filled hands."	"[The global attacker] thumps you in the gut."	"It does its best, but [the global attacker] doesn't really pose a threat to you."	"[The global attacker] hits you, but its straw hands don't do any real damage."
"Congratulations. You were killed by a being made of straw. Please do not expect me to write a serious message about how it smothered you with its evil straw-filled hands."	"[The global attacker] jumps at you, almost knocking you to the ground by its sheer weight."	"Slow and clumsy, the blows of [the global attacker] go wide."	"[The global attacker] hits you, but its straw hands don't do any real damage."
"Congratulations. You were killed by a being made of straw. Please do not expect me to write a serious message about how it smothered you with its evil straw-filled hands."	"With a masterful kick, [the global attacker] does some real damage to your [one of]left[or]right[purely at random] knee."	"[The global attacker] kicks in your general direction, but you jump aside easily."	"[The global attacker] hits you, but its straw hands don't do any real damage."



Part 2.2.5 - Plant monsters




Part 2.2.6 - Pure monsters


Chapter 2.2.6.1 - Tarrasque

A tarrasque is a kind of monster.

[The senses]

Instead of examining a tarrasque: say "A hundred meters high, covered in armour thicker than most walls, with claws as large as men and as sharp as hatred, this is undoubtedly the worst monster ever imagined."

Instead of examining a killed tarrasque: say "You KILLED the tarrasque? You are god!"; end the game in victory.

Instead of smelling a tarrasque: say "You smell your own blood.".

Instead of listening to an alive tarrasque: say "You only hear your own blood pounding in your ears."

Instead of touching a killed tarrasque: say "You KILLED the tarrasque? You are god!"; end the game in victory.

Instead of tasting a killed tarrasque: say "You KILLED the tarrasque? You are god!"; end the game in victory.


[The numbers]

The blood of a tarrasque is usually 1000.
The zeal of a tarrasque is usually 0.
The melee of a tarrasque is usually 25.
The mind of a tarrasque is usually 0.
The defence of a tarrasque is usually 30. 

The level of a tarrasque is usually 1000.


[The special]

A tarrasque is usually fast.

The damage die of a tarrasque is usually 100. The damage bonus of a tarrasque is usually 10.

[The tarrasque appears as a result of saying "xyzzy".]

The xyzzied tarrasque is a tarrasque. Rule for printing the name of the xyzzied tarrasque: say "tarrasque".



Chapter 2.2.6.2 - Imps


[Defining the imps which you can summon with Summon Imp]

An imp is a kind of monster.

The blood of an imp is usually 3.
The zeal of an imp is usually 0.
The melee of an imp is usually 0.
The mind of an imp is usually 0.
The defence of an imp is usually 1. 

The level of an imp is usually 4.

An imp is usually fireproof.
An imp is usually summoned.
The damage die of an imp is usually 2.

An imp is usually fast.

An imp is usually lowlightvisioned.

[The specific imps]

The green imp is an imp. The defence of the green imp is 2.

The red imp is an imp. The damage die of the red imp is 3.

The blue imp is an imp. The blood of the blue imp is 4.




Book 2.3 - Combat Items

Chapter 2.3.0.1 - Stick of Guarding

A stick of guarding is a kind of thing. The plural of stick of guarding is sticks of guarding. The printed plural name of stick of guarding is "sticks of guarding". Understand "stick" as stick of guarding. [Bug in Inform. TODO!]

The global guarding stick number is a number that varies. The global guarding stick number is 0.

Instead of examining a stick of guarding:
	say "This tough stick contains magical powers. Once you break it, you get a +1 defence bonus for 6 turns.".

Unprotecting is an activity.

Rule for unprotecting:
	say "The effect of the stick of guarding wears off.";
	decrease the global guarding stick number by 1.

Instead of attacking a stick of guarding:
	say "With a sharp CLICK, you snap the stick of guarding in two. You now feel protected.";	
	schedule unprotecting in 6 turns;
	increase the global guarding stick number by 1; 
	remove the noun from play.

An always-present attack modifiers rule (this is the guarding stick defence bonus rule):
	if the global guarding stick number is greater than 1 and the global defender is the player begin; [Stick of Guarding]
		say " - ", global guarding stick number," (stick of guarding)";
		decrease the to-hit modifier by global guarding stick number;
	end if;


Chapter 2.3.0.2 - Healing Herbs

A healing herbs are a kind of thing. The indefinite article of healing herbs is "some". The plural of healing herbs is packets of healing herbs. The printed plural name of healing herbs is "packets of healing herbs". Understand "packet" as healing herbs.

Instead of examining healing herbs:
	say "Eating these fresh herbs will instantly heal you for 2 Blood. It is only a small boon, but it can be the difference between life and death.".

Instead of eating healing herbs:
	say "You carefully munch the herbs, receiving ";
	heal the player for 2 blood;
	say " blood.";
	remove the noun from play.


Chapter 2.3.0.3 - Fire Grenade

A fire grenade is a kind of thing.

Instead of examining a fire grenade:
	say "Just [italic type]throw[roman type] these grenades for a fiery surprise. Be warned: these things are not safe to use, and may harm you as much as they harm your enemies.".

Instead of throwing a fire grenade at something:
	try throwing the noun.


Instead of throwing a fire grenade:
	say "You throw the fire grenade, and it explodes with a loud BANG! (";
	now the printing state is printing-fiery;
	repeat with the sucker running through alive monsters enclosed by the location begin;
		now the first dummy is a random number between 1 and 6;
		say "Rolling ", first dummy, " against a target number of 4, ";
		if the first dummy is less than 4 begin;
			if the sucker is not fireproof begin;
				say "[the sucker] catches fire. ";
				silently set fire to the sucker;
			otherwise;
				say "[the sucker] would have caught fire if it had not been resistant. ";
			end if;
		otherwise;
			say "[the sucker] does not catch fire. ";
		end if;
	end repeat;
	now the first dummy is a random number between 1 and 6;
	say "Anticipating the explosion and rolling ", first dummy, " against a target number of 3, ";
	if the first dummy is less than 3 begin;
		set fire to the player;
		say "you, alas, catch fire!)";
	otherwise;
		say "you duck away at right moment!)";
	end if;
	now the printing state is printing-normal;
	remove the noun from play.


Chapter 2.3.0.4 - Stick of Illumination

A stick of illumination is a kind of thing. The plural of stick of illumination is sticks of illumination. The printed plural name of stick of illumination is "sticks of illumination". Understand "stick" as stick of illumination. [Bug in Inform. TODO!] 

A stick of illumination is either broken or unbroken. Understand the unbroken property as describing a stick of illumination. A stick of illumination is usually unbroken. A stick of illumination is either mild or fierce. Understand the mild property as describing a stick of illumination.

A stick of illumination has a number called the illumination time. The illumination time of a stick of illumination is usually 0.

Instead of examining a stick of illumination:
	say "This tough stick contains magical powers. After you break it, it shines with a bright light for 8 turns and with low light for another 12 turns.".

Every turn:
	repeat with the potential stick running through broken sticks of illumination begin;
		decrease the illumination time of the potential stick by 1;
		if the illumination time of the potential stick is 12 begin;
			if the potential stick is visible, say "The stick of illumination glows less fiercely.";
			now the potential stick is mild;
			now the printed name of the potential stick is "broken stick of illumination, glowing mildly";
			now the printed plural name of the potential stick is "broken sticks of illumination, glowing mildly";
			now the illumination of the potential stick is 1;
		end if;
		if the illumination time of the potential stick is 0 begin;
			if the potential stick is visible, say "The stick of illumination goes dark, so you throw it away.";
			remove the potential stick from play;
		end if;
	end repeat.

Does the player mean attacking a broken stick of illumination: it is unlikely.

Instead of attacking a stick of illumination:
	if the noun is broken, say "You can only do that to an unbroken stick." instead;
	say "With a sharp CLICK, you snap the stick of illumination in two. It now shines with a bright light.";
	now the illumination of the noun is 2;
	now the illumination time of the noun is 20;
	now the noun is fierce; now the noun is broken;
	now the printed name of the noun is "broken stick of illumination, glowing fiercely";
	now the printed plural name of the noun is "broken sticks of illumination, glowing fiercely".






Volume 3 - The World


Part - Antechamber and Tutorial

The tutorial deadly combat boolean is a truth state that varies. The tutorial deadly combat boolean is false.

To do the tutorial deadly combat check:
	 if the tutorial deadly combat boolean is false, now the deadly combat bonus is 0.

Tutorial is a region. Antechamber, Lesson One - Introduction, Lesson Two - The Interface, Lesson Three - Attacking, Lesson Four - Concentrating, Lesson Five - Defending, Lesson Six - Retreating, Lesson Seven - Deadly Combat, Lesson Eight - Excitement, Lesson Nine - Skills, Lesson Ten - More Skills, Lesson Eleven - Saving, Lesson Twelve - First Fight, Lesson Thirteen - Second Fight, Lesson Fourteen - Last Fight are in Tutorial.


Chapter Antechamber

The Antechamber is a room. "This game uses many non-standard commands that allow you to test your daring and cunning in tactical combat. You'll want to familiarise yourself with them before you start the game--but how much is up to you. If you like to learn by trying, just check out the instruction leaflet. If you want a full tutorial, head [bold type]west[roman type]. If you'd prefer something in between, check out the poster here. Once you are ready to start the game, walk [bold type]south[roman type]."

The player is in Antechamber.

The instruction leaflet is in the Antechamber. Instead of examining the instruction leaflet: say "The following combat commands are essential to success: ATTACK, PARRY, DODGE, CONCENTRATE, RETREAT. They can be abbreviated as A, P, DO, C and R. Between combats, you may want to CALM DOWN. You will also want to use STATS, USE SKILL and HELP in order to get more information. During the game, you will learn new skills--check out HELP if you don't know how to use them. (You can take this leaflet with you, if you wish.)".

The instruction poster is here. Instead of examining the instruction poster: say "Here is a quick rundown of the most important new commands.[paragraph break]ATTACK or A: Use this command to attack your opponents and deal damage to them. If there is only one opponent, you don't need to specify him.[paragraph break]PARRY or P: Use this command to decrease the amount of damage you get when hit, and slightly increase the usefulness of concentration. Parrying lasts until you take an offensive action such as attacking.[paragraph break]DODGE or DO: Use this command to decrease the chance of being hit. Dodging also slightly increases your chance to hit on your next attack. Like parrying, dodging lasts until you take an offensive action. Parrying and dodging are mutually exclusive.[paragraph break]CONCENTRATE or C: Use this command to increase your chance of hitting and the amount of damage you will deal; use it multiple times for greater bonuses. Concentration can be broken when you get hit![paragraph break]RETREAT or R: Use this command to get out of a fight you cannot win.[paragraph break]CALM DOWN: Use this skill to decrease your excitement.[paragraph break]STATS: This command will give you a quick rundown of your current state.[paragraph break]USE SKILL: This command will give you a list of skills you can currently use.[paragraph break]HELP: This command takes you to the help menu.[paragraph break]In the status bar, you can see your Blood, your Zeal and your current excitement. (Make sure your window is wide enough to see them all!) Blood measures your health; if it drops to 0, you're dead. Zeal is needed for using the special skills you'll learn during the game. Excitement gives you bonuses when you fight: indeed, getting as high an excitement as possible is by far the best way to increase your combat prowess! You can increase your excitement by hitting, killing and getting hit; by using certain skills and items; and by not concentrating, by making sure that you're never out of combat for long and by not calming down. But beware: if your excitement gets too high, you'll get a fatal heart attack! (Which is why you might want to calm down now and then.)[paragraph break]You may take this poster with you, if you wish.".

Before going south in Antechamber:
	now the tutorial deadly combat boolean is true;
	repeat through the Table of Player Skills begin;
		change the have entry to 0;
	end repeat;
	now the blood of the player is 20;
	now the permanent blood of the player is 20;
	now the zeal of the player is 10;
	now the permanent zeal of the player is 10;
	clear the screen;
	say "Welcome to [bold type]Idols of War[roman type]! You have entered the ancient Temple of the four illustrious Gods of War, ready to please them by fighting monsters and sacrificing valuable gems. Will you be able to master combat and rise to even the hardest challenges? It is time to find out.".


Chapter - Tutorial Lesson 1

Lesson One - Introduction is a room. "In this tutorial, you will learn the basics of the tactical combat system used in the game. That's right, [italic type]tactical[roman type] combat--you won't overcome your enemies by just typing 'attack' over and over again. If you're ready to start learning, please proceed to the [bold type]west[roman type]."


Lesson One - Introduction is west of the Antechamber.


Chapter - Tutorial Lesson 2


Lesson Two - The Interface is west of Lesson One - Introduction. "Let us talk about the interface first. At the top left of your screen, you will see the name of the room you are currently in: 'Lesson Two - The Interface'. To the right of the room name is the most essential combat information: first your Blood in the middle, then your your Zeal to the right. Check out the Blood poster here if you wish to learn more about that--all the other features will be explained in later lessons.[paragraph break]On the second line, you can see which of the four Idols of War favour and disfavour you, and to the right, what your state of excitement is.[paragraph break]On the third line, you can see the current deadly combat bonus, the number of turns to the next Beat, and the Beat Bonus. Again, all of this will be explained in more detail later. (Please make sure that the window of your interpreter is wide enough to show all this information.) You can now proceed to the [bold type]west[roman type] or go back [bold type]east[roman type]."


In Lesson Two - The Interface is the Blood Poster.

The Blood Poster is fixed in place. Instead of examining the Blood Poster: say "Blood designates your health. If your Blood ever drops to 0, you will die--which is something you should avoid. The status bar shows two values: the first is your current Blood, the second is your maximum Blood. In general your current Blood cannot be higher than your maximum Blood.[paragraph break]You lose Blood by getting hit by your enemies, and you regain Blood by killing enemies. (There are other ways to lose and regain Blood, but you'll have to find out about those during the game.)".



[The Circle Poster is fixed in place. Instead of examining the Circle Poster: say "The main game is divided into several circles, or regions. This is important for the game mechanics in several ways. First, saving in combat costs more Zeal in higher circles; second, powerful skills granted by the Gods can only be learned and used in higher circles. You'll find out more about circles as you play the game; there is no need to worry about it now.".]


Chapter - Tutorial Lesson 3

Lesson Three - Attacking is west of Lesson Two - The Interface. "Enough talk--let's have some action. In this lesson, we will learn the most basic combat action: attacking. Just attack the straw man by typing 'attack straw man'. Don't worry, he won't be able to attack you. Once the straw man is dead, you can proceed to the [bold type]west[roman type] or go back to the [bold type]east[roman type]."



The straw man is a straw being in Lesson Three - Attacking. 

The defence of the straw man is 0. 


After attacking in Lesson Three - Attacking for the first time:
	say "[bold type]You'll be seeing something like this: 'Rolling 5 + 1 = 6, you beat the straw man's defence rating of 0. You deal 2 - 1 (calm) = 1 damage, wounding the straw man to 9 blood.' What does that mean?[paragraph break]The first number is the result of a random roll between 1 and 10. To this is added your attack bonus, which is currently 1. There are no other modifiers, so the result is the sum of these two numbers.[paragraph break]If this result is higher than 0--the defence rating of the straw man--you hit. (Of course, most of your enemies will have a higher defence rating than this straw man.) When you hit your enemy, you deal damage. The amount of damage you deal is a random number between 1 and 6, plus any modifiers. In this case, you got a - 1 damage penalty for being calm; this penalty will go away and then turn into a bonus as your excitement increases. (You'll learn more about excitement later.)[paragraph break]Now attack the straw man some more.[roman type][paragraph break]". 


After attacking in Lesson Three - Attacking for the second time:
	say "[bold type]It may be good to know that you can abbreviate 'attack' to 'a'. If there is only one enemy around, you can even leave out the name of the enemy: just 'a' will work fine.[roman type][paragraph break]"


Chapter - Tutorial Lesson 4

Lesson Four - Concentrating is west of Lesson Three - Attacking. "Things would get boring quickly if all you could do was type 'attack', so in most of this tutorial we will be concerned with adding new options. The first option we will add is 'concentrate'. Concentrating is a great way to increase both your attack bonus and your damage bonus. Just type 'concentrate' or 'c' to try it out. Once you are ready, proceed to the [bold type]west[roman type] or go back to the [bold type]east[roman type]."


The tutorial lesson four number is a number that varies. The tutorial lesson four number is 0.

The straw woman is a straw being in Lesson Four - Concentrating. 

The blood of the straw woman is 16.

The erratic attack failure text of the straw woman is "The straw woman [one of]would have attacked you, had she been able to[or]just stands there[or]awaits your fury[at random].[paragraph break]".


After concentrating in Lesson Four - Concentrating for the first time:
	say "[bold type]Great! Now attack the straw woman to see your bonus in action.[roman type][paragraph break]"; now the tutorial lesson four number is 1.

After concentrating in Lesson Four - Concentrating for the second time:
	if the tutorial lesson four number is 1, now the tutorial lesson four number is 3. [Don't tell about multiple concentrations if the player has already found this out herself.]

After concentrating in Lesson Four - Concentrating for the third time:
	say "[bold type]An important tip: if you are damaged while concentrating, you may lose your concentration! That's not relevant here, since the straw woman never hits you--but it will be important in real fights.[roman type][paragraph break]"

After attacking in Lesson Four - Concentrating:
	if the tutorial lesson four number is 1 begin;
		say "[bold type]Very good. But that wasn't a very significant bonus, was it? Luckily, you can boost your concentration bonus by concentrating up to three times in a row before attacking--try it now! You can proceed to the next room after you've killed the straw woman.[roman type][paragraph break]";
		now the tutorial lesson four number is 2;
	end if.

Before going west in Lesson Four - Concentrating for the first time:
	now the blood of the player is 1000;
	now the permanent blood of the player is 1000.


Chapter - Tutorial Lesson 5

Lesson Five - Defending is west of Lesson Four - Concentrating. "In this lesson, you will learn two additional standard combat commands: [italic type]parry[roman type] and [italic type]dodge[roman type]. The monster here can actually attack you, and these two commands will help you resist his attacks. Try them out, then defeat the monster using what you learned in the previous lessons. Don't worry about dying; we've temporarily given you 1000 Blood. Once you are ready, either go [bold type]south[roman type] to Lesson Six, [bold type]west[roman type] to Lesson Seven, or back [bold type]east[roman type]."


The straw golem is a straw being in Lesson Five - Defending.

The straw golem is not an erratic attacker.
The blood of the straw golem is 12.
The melee of the straw golem is 0.
The damage die of the straw golem is 5.


After parrying in Lesson Five - Defending for the first time:
	say "[bold type]Very good! When you are parrying your opponents[apostrophe] attacks, you will receive less damage from them. (A random amount between 0 and 4 damage is subtracted from the damage you would otherwise have received.) In addition, parrying slightly improves the results of concentrating. Parrying lasts until you attack, use an offensive skill or dodge; but you can concentrate or use a defensive skill without breaking your parry.[roman type][paragraph break]".

After parrying in Lesson Five - Defending for the second time:
	say "[bold type]By the way, you can abbreviate 'parry' to 'p'.[roman type]".

After dodging in Lesson Five - Defending for the first time:
	say "[bold type]Very good! When you are dodging your opponents[apostrophe] attacks, your defence increases by 2, making it harder for your opponents to hit you. In addition, dodging gives a slight bonus to the next attack. Dodging lasts until you attack, use an offensive skill or parry; but you can concentrate or use a defensive skill without breaking your dodge.[roman type][paragraph break]".

After dodging in Lesson Five - Defending for the second time:
	say "[bold type]By the way, you can abbreviate 'dodge' to 'do'.[roman type]".

Before going west in Lesson Five - Defending for the first time:
	now the tutorial deadly combat boolean is true;
	now the blood of the player is 20;
	now the permanent blood of the player is 20.


Chapter - Tutorial Lesson 6

Lesson Six - Retreating is south of Lesson Five - Defending. "You now face an opponent whom you will not be able to defeat. (You can try if you wish!) The only action left to you in such circumstances is to [italic type]retreat[roman type]--try it now. You can then proceed directly from Lesson Five to Lesson Six."

The straw dragon is a straw being in Lesson Six - Retreating. "A really tough-looking straw dragon dominates this room."

The blood of the straw dragon is 1000.
The defence of the straw dragon is 25.
The damage reduction of the straw dragon is 40.

Before retreating in Lesson Six - Retreating for the first time:
	say "[bold type]A word of advice: retreating does not always work. Your chance of success depends on the number of opponents you face, their speed, and your health relative to theirs. So be careful, and don't get into fights you can neither win nor run away from.[roman type][paragraph break]".


Chapter - Tutorial Lesson 7

Lesson Seven - Deadly Combat is west of Lesson Five - Defending. "I have to admit that we've cheated a bit in the previous lessons. A very important dimension of fighting is 'deadly combat', but in order not to confuse you, we turned it off for the first six lessons. It's back on now--so please read the poster, fight the monster, and see deadly combat in action. Once you're ready, you can proceed to the [bold type]west[roman type]."

The Deadly Combat Poster is here. Instead of examining the Deadly Combat Poster: say "Consider the dynamics of fighting. Sometimes, people are hitting each other constantly. At other times, there is a temporary stand-off: everybody misses, they are concentrating or defending, or they are using non-offensive skills. During those moments, the tension is building--and the audience knows that the next blow is going to be important![paragraph break]That is the 'deadly combat' system of this game emulates. If nobody gets hit in an entire round of combat, then the deadly combat bonus is set to 1. This means that next turn, all combatants will have a +1 bonus to their attack roll and their damage. If nobody gets hit again, the bonus is raised to 2, then to 3, then to 4, and finally to a maximum of 5. If, on the other hand, a hit is scored in this round, then next round, the deadly combat bonus will be 2 lower than it currently is. (The minimum is always 0.)[paragraph break]It pays to keep an eye on the deadly combat bonus, which you can see in the status bar. You don't want to miss the opportunity to hit your opponent with a +5 bonus![paragraph break]You can easily try out deadly combat in this room: just concentrate, parry or dodge for a few round, then attack your opponent. You will immediately see the bonuses in action.[paragraph break](Please note that several actions in this game, such as examining and looking, do not take any time. Thus, no round passes when you take them, and the deadly combat bonuses will not change.)".

The straw chicken is a straw being in Lesson Seven - Deadly combat.

The defence of the straw chicken is 9. The blood of the straw chicken is 22.

The erratic attack failure text of the straw chicken is "The straw chicken [one of]would have attacked you, had she been able to[or]just stands there[or]awaits your fury[at random].[paragraph break]".


Chapter - Tutorial Lesson 8

Lesson Eight - Excitement is west of Lesson Seven - Deadly Combat. "There is something else you haven't seen yet: excitement. See where it says [excitement of the player] in the top right corner of the status bar? That's your excitement state. The more excited you are, the greater your chance of hitting and the more damage you do--bonuses which can become very significant at high levels of excitement. Check out the poster here, then push the button and defeat your opponent! The next lesson lies to the [bold type]west[roman type]."

The Excitement Poster is here.

The Excitement Poster is fixed in place. Instead of examining the Excitement Poster: say "Excitement is a measure of your passion, anger, hatred, frustration--everything that drives you to prevail in combat. You start out Calm, but you can become Animated, Excited, Agitated, Frantic and Frenzied during the game. Higher states of excitement give you bigger combat bonuses.[paragraph break]You may gain Excitement by killing, by hitting and by being hit--this is randomly determined. (It's not going to happen as long as we let you fight straw beings, though: they are not that exciting.) There are also some skills and items that allow you to raise your excitement. On the opposite side, you'll gradually lose Excitement when you are not in combat, and you can lower it yourself by either concentrating or calming down. (Why would you ever want to lower it? Because if you get [italic type]too[roman type] excited, you'll suffer a fatal heart attack! You must walk a fine line here.)[paragraph break]Try it out by pressing the button!".

The excitement button is here. The excitement button is fixed in place. Instead of examining the excitement button: say "Not very exciting, until you press it.".

Instead of pushing the excitement button:
	if the player is not frenzied begin;
		increase the excitement of the player;
		say "You become [excitement of the player]!";
	otherwise;
		say "You are already as excited as the button can make you.";
	end if.


The straw frog is a straw being in Lesson Eight - Excitement. The defence of the straw frog is 14. The blood of the straw frog is 30.

Check going in Lesson Eight - Excitement:
	if the player is not calm, say "Sorry--you'll have to calm down before you can leave here. There are a couple of ways to do that: you could stand around and wait; you could concentrate; but the best way is to type 'calm down'." instead.

Instead of going west in Lesson Eight - Excitement:
	choose row with a Skill of Smashing Blow in the Table of Player Skills;
	now the have entry is 1;
	continue the action.


Chapter - Tutorial Lesson 9

Lesson Nine - Skills is west of Lesson Eight - Excitement. "Okay, it's time for you to learn and try out your first skill. During the game, you'll get more and more skills from the Idols of War. Each of these skills is basically a new command that becomes available to you, and therefore a new option in combat. By entering this room, you have temporarily learnt the Smashing Blow skill. This gives you a new attack command, 'smash', which allows you to do extra damage. However, notice that it costs Zeal to use this skill! Check out the Smash Poster and the Zeal Poster for more info. Go [bold type]west[roman type] when you're ready."

The straw tomato is a straw being in Lesson Nine - Skills. The defence of the straw tomato is 6. The blood of the straw tomato is 30.

The Zeal Poster is here. The Smash Poster is here.

The Zeal Poster is fixed in place. Instead of examining the Zeal Poster: say "Zeal measures your standing with the Gods of War. You will need Zeal to use special skills taught by the Gods. The Status Bar shows two values: the first is your current Zeal, the second is your maximum Zeal. In general, your current Zeal cannot be higher than your maximum Zeal.[paragraph break]Your Zeal decreases when you use special skills. This decrease is not constant, but depends on the number of times you've already used that skill since the last time you won a combat. A skill that costs 1 Zeal the first time you use it will cost 2 Zeal the second time, 3 Zeal the third time, and so on. So as you acquire more skills, it's a good idea to use all of them rather than rely on only a few.[paragraph break]Another factor that affects Zeal cost is which of the Gods currently favour or disfavour you. If a God favours you, it's as if you used all of his skills one less time than you actually did--which means that your first use of each skill of a God that favours you is actually [italic type]free[roman type]! If a God disfavours you, it's as if you have used all their skills one more time than you actually have. (In case you're wondering, 'Smashing Blow' is a Groth skill, so if he is favouring you, you're lucky!)[paragraph break]Your Zeal increases when you win particularly hard fights.".

The Smash Poster is fixed in place. Instead of examining the Smash Poster: say "SMASHING BLOW[paragraph break]Type '[roman type]smash [italic type]opponent[roman type]' to use this Groth skill, which costs 1 Zeal on your first use. (See the Zeal Poster for more information on Zeal costs.)[paragraph break]Groth lends strength to your attack, allowing you to do extra damage. If you miss, the blow is wasted. If you hit, you'll do 1, 2, 3, 4, 6 or 8 extra damage--the exact result is determined randomly. Smashing blow counts as a regular melee attack."


Instead of going west in Lesson Nine - Skills:
	choose row with a Skill of Bronze Armour in the Table of Player Skills;
	now the have entry is 1;
	choose row with a Skill of Burning Hands in the Table of Player Skills;
	now the have entry is 1;
	choose row with a Skill of Await in the Table of Player Skills;
	now the have entry is 1;
	now the zeal of the player is 10;
	continue the action.


Chapter - Tutorial Lesson 10

Lesson Ten - More Skills is west of Lesson Nine - Skills. "Okay, we're going to give you three other skills to play around with. The first is 'Bronze Armour', an Elda skill that will conjure a suit of armour around you that helps protect you from harm. The second is 'Burning Hands', a Duncan skill that allows you to set fire to your enemies. And the third is 'Await', a Shliss skill that gives you the ability to prepare for an attack with extra precision. Read the posters, and continue to the [bold type]west[roman type] when you are ready."

The Bronze Poster is here. The Burning Poster is here. The Waiting Poster is here. [TO DO. Need an Inform 7 bug fix first.]

The Bronze Poster is fixed in place. Instead of examining the Bronze Poster: say "BRONZE ARMOUR[paragraph break]To use, type 'bronze armour' or simply 'bronze'. The standard cost of this Elda skill is 1 Zeal.[paragraph break]The effect of Bronze Armour is twofold. On the positive side, it protects you from harm. All attacks against you will have a 50% chance of being stopped by the bronze armour. When so stopped, the damage dealt by the attack is reduced by 3; so, if you would normally have gotten 5 damage, you will now get only 2. In addition, Bronze Armour's damage resistance slightly increases as combat deadliness goes up--so it helps takes the worst edge off particularly painful attacks. Your bronze armour will disappear when it has been hit 4 times, or when combat ends.[paragraph break]On the negative side, bronze armour gives you a slight -1 attack penalty. This too disappears when the armour has been used up.".

The Burning Poster is fixed in place. Instead of examining the Burning Poster: say "BURNING HANDS[paragraph break]To use, type 'burn [italic type]enemy[roman type]'. The standard cost of this Duncan skill is 1 Zeal.[paragraph break]When you try to burn an opponent, you have to walk right up to him--which means that he first gets a free attack against you. Irrespective of whether he hits or misses, you then get to make an attack against him at a +1 bonus. If you hit, the enemy will not only receive 1 to 3 damage, he will also have a 2 in 3 chance of catching fire. This fire deals 1 to 5 damage every turn for 5 turns--so that's another 5 to 25 damage.[paragraph break]But be careful--you are, after all, playing with fire."

The Waiting Poster is fixed in place. Instead of examining the Waiting Poster: say "AWAIT[paragraph break]To use, type 'await [italic type]number[roman type]'. This number can be anything, as long as it's positive; let's call it [italic type]n[roman type]. Await normally costs 2 Zeal.[paragraph break]The result of awaiting is that after [italic type]n[roman type] turns, you can make an attack with a + [italic type]n[roman type] melee bonus that also does + [italic type]n[roman type] damage. So, 'await 3' will allow you to make an attack with a +3 melee and damage bonus 3 rounds from now.[paragraph break]However, there is one important restriction: while you are awaiting your chance, you are not allowed to attack or take another offensive action (such as using Smashing Blow or Burning Hands). If you do attack early, your await bonus is cancelled. (This means that although 'await 20' would give you a massive bonus after 20 turns, you'd also have to refrain from attacking for 19 turns first, which is not so good.)"



Chapter - Tutorial Lesson 11

Lesson Eleven - Saving is west of Lesson Ten - More Skills. "Okay, one last lesson before we let you engage in some real fights. There is danger to the [bold type]west[roman type]--so this would be a good moment to SAVE your game. If you get killed accidentally, you can then RESTORE to this position. Note that saving (like undoing) costs Zeal. However, don't worry: if you don't have enough Zeal, you'll still be allowed to save--as long as you are not in combat. In combat, you can only save if you have enough Zeal."



Chapter - Tutorial Lesson 12

Lesson Twelve - First Fight is west of Lesson Eleven - Saving. "Monsters! Kill them using your skills, then proceed to the [bold type]west[roman type]. (You can always review the skills you have by typing 'list skills', and you can see for which skills you actually have enough Zeal by typing 'use skills'. This will not cost you a turn.)"

In Lesson Twelve - First Fight are a bat and a mud crab.



Chapter - Tutorial Lesson 13

Lesson Thirteen - Second Fight is west of Lesson Twelve - First Fight. "More monsters! Kill them all, then go [bold type]west[roman type]. Beware: this fight will not be easy! You may want to save when you have won. (If you want to keep track of what effects are active upon you, type 'stats' at any time. This will not cost you a turn. Remember it well, for it is a very useful command.)"

In Lesson Thirteen - Second Fight are a vampire bat, a snake and a young troll.



Chapter - Tutorial Lesson 14

Lesson Fourteen - Last Fight is west of Lesson Thirteen - Second Fight. "Okay, this is the last fight of the tutorial! And we are introducing the final feature of the game: beat. Beat is the rhythm of combat; and when the beat comes, everyone has a damage bonus; in addition, you get more Blood when you kill someone when the beat is there! Try it out, then return to the Antechamber by going [bold type]south[roman type]."

The location beat of Lesson Fourteen - Last Fight is 4. The location beat strength of Lesson Fourteen - Last Fight is 5.

In Lesson Fourteen - Last Fight is a giant mud crab.

The Antechamber is south of Lesson Fourteen - Last Fight. North of the Antechamber is nowhere.



Part - Main Area


Chapter - Central Hall

Central Hall is a room. "This vast and empty hall is the central hub of the Temple. You can go [bold type]north[roman type] to the Hall of Challenges; [bold type]south[roman type] to the Hall of Dungeons; [bold type]west[roman type] to the Hall of Scenarios; or [bold type]east[roman type] to the Hall of Adventures. If you have gems to sacrifice, you may wish to go [bold type]northwest[roman type] to the Shrine of Groth; [bold type]northeast[roman type] to the Shrine of Elda; [bold type]southwest[roman type] to the Shrine of Duncan; or [bold type]southeast[roman type] to the Shrine of Shliss."

Central Hall is south of Antechamber. In Central Hall is a fire grenade.




Chapter - Hall of Challenges

North of Central Hall is Hall of Challenges. The description of the Hall of Challenges is "Challenges are single fights with one particularly tough monster, or a monster and its underlings. Fight the [italic type]Troll[roman type] (easy) to the [bold type]west[roman type], or the [italic type]Ugly Troll[roman type] (easy) to the [bold type]north[roman type]. Central Hall lies back [bold type]south[roman type]."
 

Chapter - Hall of Dungeons

Hall of Dungeons is south of Central Hall. "Dungeons are areas where all the monsters (and some of the treasures) respawn after they have all been killed. You can visit them multiple times! To the [bold type]northwest[roman type] lies the [italic type]Forest[roman type] (very easy). To the [bold type]west[roman type] lies the [italic type]Bat Cave[roman type] (easy). The Central Hall lies back [bold type]north[roman type]."


Chapter - Hall of Scenarios

West of Central Hall is Hall of Scenarios. The description of Hall of Scenarios is "Scenarios are story-driven series of fights. You can go [bold type]west[roman type] for [italic type]Final Confrontation[roman type]. Central Hall lies back [bold type]east[roman type]."


Chapter - Hall of Adventures

East of Central Hall is Hall of Adventures. The description of Hall of Adventures is "Adventures are areas where you won't just find monsters, but also interesting scenery with which you can interact and which will influence combat. Currently, no adventures are implemented. Central Hall lies back [bold type]west[roman type]."



Part Shrines

[Diamond]

A diamond is a kind of thing. Instead of examining a diamond, say "Crudely cut, yet very big--just the kind of treasure you should put into the mouth of an idol in order to learn a skill.".

In the Central Hall is a diamond.

An idol has a number called the first level skills number. The first level skills number of an idol is usually 0.

[Ruby]

A ruby is a kind of thing. Instead of examining a ruby, say "A small but perfect red gem--just the kind of treasure you should put into the mouth of an idol in order to get a statistics boost.".

In the central hall are 6 rubies.

An idol has a number called the ruby number.

[More stuff about idols]

Check inserting something into an idol:
	if the noun is not a diamond and the noun is not a ruby, say "The Idol will only accept a diamond or a ruby!" instead.

Carry out inserting something into an idol:
	say "You should never see this text!";
	stop the action.
	
Check removing something from an idol:
	say "There is no way to retrieve what you have given to the idol." instead.

Instead of giving something to an idol:
	try inserting the noun into the second noun.


Chapter - Shrine of Groth

Shrine of Groth is northwest of Central Hall. "This room is dominated by the Idol of Groth--a bulging mass of flesh and muscle; fierce, naked and terrifying. Groth's mouth is wide open in a hungry growl. The Central Hall lies [bold type]southeast[roman type]."

The Groth Idol is here. It is scenery and fixed in place. Instead of examining the Groth Idol, say "The Idol of Groth is a bulging mass of flesh and muscle; fierce, naked and terrifying. Groth's mouth is wide open in a hungry growl." Understand "mouth" as the Groth Idol.

[Ruby: gives + 1 HP, except for every fifth, which gives +1 melee.]

Instead of inserting a ruby into the Groth idol:
	remove the noun from play;
	increase the ruby number of the Groth idol by 1;
	if the remainder after dividing the ruby number of the Groth Idol by 5 is 0 begin;
		say "Your melee increases by 1!";
		increase melee of the player by 1;
	otherwise;
		say "Your permanent Blood increase by 1!";
		increase blood of the player by 1;
		increase permanent blood of the player by 1;
	end if.


[Diamonds teach: Deadlier Combat, Smashing Blow, Anger, Greater Cleave. ]

c_GrothSkills_1, c_GrothSkills_2, c_GrothSkills_3, c_GrothSkills_4, c_GrothSkills_5 are chat nodes.

Instead of inserting a diamond into the Groth Idol:
	remove the noun from play;
	if the first level skills number of the Groth Idol is 4, say "You have already learned all Groth skills currently implemented!" instead;
	run a conversation from c_GrothSkills_1.
	
Instead of giving text for c_GrothSkills_1: say "Apprehensively, you throw the diamond into Groth's wide-open mouth. He swallows it immediately and offers to teach you a skill! What would you like to learn?".
Instead of finding responses to c_GrothSkills_1: link to c_GrothSkills_2; link to c_GrothSkills_3; link to c_GrothSkills_4; link to c_GrothSkills_5.

Instead of giving link to c_GrothSkills_2: say "Learn [italic type]Smashing Blow[roman type], which gives you an alternative attack that deals up to 8 more damage than a normal attack.".
Instead of giving text for c_GrothSkills_2:
	teach Smashing Blow;
	deactivate c_GrothSkills_2;
	increase the first level skills number of the Groth Idol by 1.

Instead of giving link to c_GrothSkills_3: say "Learn [italic type]Greater Cleave[roman type], an automatically activated skill that radically improves your cleave attack.".
Instead of giving text for c_GrothSkills_3:
	teach Greater Cleave;
	deactivate c_GrothSkills_3;
	increase the first level skills number of the Groth Idol by 1.

Instead of giving link to c_GrothSkills_4: say "Learn [italic type]Anger[roman type], which allows you to temporarily boost your excitement, gaining all the associated bonuses.".
Instead of giving text for c_GrothSkills_4:
	teach Anger;
	deactivate c_GrothSkills_4;
	increase the first level skills number of the Groth Idol by 1.

Instead of giving link to c_GrothSkills_5: say "Learn [italic type]Deadlier Combat[roman type], which doubles all deadly combat bonuses for the duration of a single fight.".
Instead of giving text for c_GrothSkills_5:
	teach Deadlier Combat;
	deactivate c_GrothSkills_5;
	increase the first level skills number of the Groth Idol by 1.


Chapter - Shrine of Elda


Shrine of Elda is northeast of Central Hall. "This room is dominated by the Idol of Elda--a stern and regal lady carrying a huge shield. Elda's mouth is wide open in a shout of defiance. The Central Hall lies [bold type]southwest[roman type]."

The Elda Idol is here. It is scenery and fixed in place. Instead of examining the Elda Idol, say "The Idol of Elda is a stern and regal lady carrying a huge shield. Elda's mouth is wide open in a shout of defiance." Understand "mouth" as the Elda Idol.

[Ruby: gives + 1 HP, except for every fifth, which gives +1 defence.]

Instead of inserting a ruby into the Elda idol:
	remove the noun from play;
	increase the ruby number of the Elda idol by 1;
	if the remainder after dividing the ruby number of the Elda Idol by 5 is 0 begin;
		say "Your defence increases by 1!";
		increase defence of the player by 1;
	otherwise;
		say "Your permanent Blood increase by 1!";
		increase blood of the player by 1;
		increase permanent blood of the player by 1;
	end if.


[Diamonds teach: Deadlier Combat, Smashing Blow, Anger, Greater Cleave. ]

c_EldaSkills_1, c_EldaSkills_2, c_EldaSkills_3, c_EldaSkills_4, c_EldaSkills_5 are chat nodes.

Instead of inserting a diamond into the Elda Idol:
	remove the noun from play;
	if the first level skills number of the Elda Idol is 4, say "You have already learned all Elda skills currently implemented!" instead;
	run a conversation from c_EldaSkills_1.
	
Instead of giving text for c_EldaSkills_1: say "Apprehensively, you throw the diamond into Elda's wide-open mouth. She swallows it immediately and offers to teach you a skill! What would you like to learn?".
Instead of finding responses to c_EldaSkills_1: link to c_EldaSkills_2; link to c_EldaSkills_3; link to c_EldaSkills_4; link to c_EldaSkills_5.

Instead of giving link to c_EldaSkills_2: say "Learn [italic type]Bronze Armour[roman type], a skill that temporarily gives you a damage absorbing armour that slightly hinders your attacks.".
Instead of giving text for c_EldaSkills_2:
	teach Bronze Armour;
	deactivate c_EldaSkills_2;
	increase the first level skills number of the Elda Idol by 1.

Instead of giving link to c_EldaSkills_3: say "Learn [italic type]Curse[roman type], which allows you to decrease the melee skills of your enemies until they manage to hit you.".
Instead of giving text for c_EldaSkills_3:
	teach Curse;
	deactivate c_EldaSkills_3;
	increase the first level skills number of the Elda Idol by 1.

Instead of giving link to c_EldaSkills_4: say "Learn [italic type]Shield[roman type], a skill that summons a magical shield that improves the parry action.".
Instead of giving text for c_EldaSkills_4:
	teach Shield;
	deactivate c_EldaSkills_4;
	increase the first level skills number of the Elda Idol by 1.

Instead of giving link to c_EldaSkills_5: say "Learn [italic type]Gaseous Form[roman type], a skill that allows you to become immaterial for a single round, making you entirely immune from physical damage.".
Instead of giving text for c_EldaSkills_5:
	teach Gaseous Form;
	deactivate c_EldaSkills_5;
	increase the first level skills number of the Elda Idol by 1.


Chapter - Shrine of Duncan

Shrine of Duncan is southwest of Central Hall. "This room is dominated by the Idol of Duncan--a crazed youth enveloped by a mass of flames. Duncan's mouth is wide open in a scream of either agony or ecstasy. The Central Hall lies [bold type]northeast[roman type]."

The Duncan Idol is here. It is scenery and fixed in place. Instead of examining the Duncan Idol, say "The Idol of Duncan is a crazed youth enveloped by a mass of flames. Duncan's mouth is wide open in a scream of either agony or ecstasy." Understand "mouth" as the Duncan Idol.

[Ruby: gives some kind of bonus every third ruby.]

Instead of inserting a ruby into the Duncan idol:
	remove the noun from play;
	increase the ruby number of the Duncan idol by 1;
	if the remainder after dividing the ruby number of the Duncan Idol by 4 is 0 begin;
		say "You can now deal 1 more damage on a standard attack!";
		increase damage die of the player by 1;
	otherwise;
		say "Your sacrifice is accepted, but more rubies must be offered to Duncan before you will receive any boons.";
	end if.


[Diamonds teach: Deadlier Combat, Smashing Blow, Anger, Greater Cleave. ]

c_DuncanSkills_1, c_DuncanSkills_2, c_DuncanSkills_3, c_DuncanSkills_4, c_DuncanSkills_5 are chat nodes.

Instead of inserting a diamond into the Duncan Idol:
	remove the noun from play;
	if the first level skills number of the Duncan Idol is 4, say "You have already learned all Duncan skills currently implemented!" instead;
	run a conversation from c_DuncanSkills_1.
	
Instead of giving text for c_DuncanSkills_1: say "Apprehensively, you throw the diamond into Duncan's wide-open mouth. She swallows it immediately and offers to teach you a skill! What would you like to learn?".
Instead of finding responses to c_DuncanSkills_1: link to c_DuncanSkills_2; link to c_DuncanSkills_3; link to c_DuncanSkills_4; link to c_DuncanSkills_5.

Instead of giving link to c_DuncanSkills_2: say "Learn [italic type]Burning Hands[roman type], which grants you a special attack that can set your enemies on fire.".
Instead of giving text for c_DuncanSkills_2:
	teach Burning Hands;
	deactivate c_DuncanSkills_2;
	increase the first level skills number of the Duncan Idol by 1.

Instead of giving link to c_DuncanSkills_3: say "Learn [italic type]Summon Imps[roman type], a skill that you can use to summon three imps to help--or hinder--you. (This skill costs 2 Zeal.)".
Instead of giving text for c_DuncanSkills_3:
	teach Summon Imps;
	deactivate c_DuncanSkills_3;
	increase the first level skills number of the Duncan Idol by 1.

Instead of giving link to c_DuncanSkills_4: say "Learn [italic type]Scout[roman type], which will allow you to check out unknown areas with less chance of being unable to retreat.".
Instead of giving text for c_DuncanSkills_4:
	teach Scout;
	deactivate c_DuncanSkills_4;
	increase the first level skills number of the Duncan Idol by 1.

Instead of giving link to c_DuncanSkills_5: say "Learn [italic type]Fire Bomb[roman type], which allows you to create a time bomb that will set everyone in the location on fire. (This skill costs 2 Zeal.)".
Instead of giving text for c_DuncanSkills_5:
	teach Fire Bomb;
	deactivate c_DuncanSkills_5;
	increase the first level skills number of the Duncan Idol by 1.


Chapter - Shrine of Shliss


Shrine of Shliss is southeast of Central Hall. "This room is dominated by the Idol of Shliss--a robed figure, neither obviously masculine nor feminine, with pensive eyes and a sly smile. Shliss's mouth is opened very little, but you might just be able to put a gem into it. The Central Hall lies [bold type]northwest[roman type]."

The Shliss Idol is here. It is scenery and fixed in place. Instead of examining the Shliss Idol, say "The Idol of Shliss is a robed figure, neither obviously masculine nor feminine, with pensive eyes and a sly smile. Shliss's mouth is opened very little, but you might just be able to put a gem into it." Understand "mouth" as the Shliss Idol.

[Ruby: gives some kind of bonus every third ruby.]

Instead of inserting a ruby into the Shliss idol:
	remove the noun from play;
	increase the ruby number of the Shliss idol by 1;
	if the remainder after dividing the ruby number of the Shliss Idol by 3 is 0 begin;
		say "Your Zeal increases by 1!";
		increase zeal of the player by 1;
		increase permanent zeal of the player by 1;
	otherwise;
		say "Your sacrifice is accepted, but more rubies must be offered to Shliss before you will receive any boons.";
	end if.


[Diamonds teach: Deadlier Combat, Smashing Blow, Anger, Greater Cleave. ]

c_ShlissSkills_1, c_ShlissSkills_2, c_ShlissSkills_3, c_ShlissSkills_4, c_ShlissSkills_5 are chat nodes.

Instead of inserting a diamond into the Shliss Idol:
	remove the noun from play;
	if the first level skills number of the Shliss Idol is 4, say "You have already learned all Shliss skills currently implemented!" instead;
	run a conversation from c_ShlissSkills_1.
	
Instead of giving text for c_ShlissSkills_1: say "Apprehensively, you throw the diamond into Shliss's wide-open mouth. [one of]She[or]He[purely at random] swallows it immediately and offers to teach you a skill! What would you like to learn?".
Instead of finding responses to c_ShlissSkills_1: link to c_ShlissSkills_2; link to c_ShlissSkills_3; link to c_ShlissSkills_4; link to c_ShlissSkills_5.

Instead of giving link to c_ShlissSkills_2: say "Learn [italic type]Needle[roman type], which allows you to deal a small amount of damage to an enemy without having to make a successful attack.".
Instead of giving text for c_ShlissSkills_2:
	teach Needle;
	deactivate c_ShlissSkills_2;
	increase the first level skills number of the Shliss Idol by 1.

Instead of giving link to c_ShlissSkills_3: say "Learn [italic type]Determination[roman type], a skill that allows you to improve your concentration: you'll no longer automatically lose it when you are hit. (This skill costs 2 Zeal.)".
Instead of giving text for c_ShlissSkills_3:
	teach Determination;
	deactivate c_ShlissSkills_3;
	increase the first level skills number of the Shliss Idol by 1.

Instead of giving link to c_ShlissSkills_4: say "Learn [italic type]Sacrifice[roman type], which allows you to sacrifice an amount of your own Blood in order to deal more damage to your opponent.".
Instead of giving text for c_ShlissSkills_4:
	teach Sacrifice;
	deactivate c_ShlissSkills_4;
	increase the first level skills number of the Shliss Idol by 1.

Instead of giving link to c_ShlissSkills_5: say "Learn [italic type]Await[roman type], a tactical skill that allows you to make a powerful attack after defending for a predetermined number of rounds. (This skill costs 2 Zeal.)".
Instead of giving text for c_ShlissSkills_5:
	teach Await;
	deactivate c_ShlissSkills_5;
	increase the first level skills number of the Shliss Idol by 1.



Part - Dungeon 1--The Bat Cave



The Bat Cave is a dungeon. Entrance to the Bat Cave, Forking Passage, Hall of Guano, Dark Junction, Darkest Cave, Low Passage, Leaking Tunnel, The Troll Cellar, Muddy Tunnel and Northern Cave Entrance are in the Bat Cave.

The bat cave cache is a treasure chest. The cache of the bat cave is the bat cave cache. In the bat cave cache are three sticks of guarding, two fire grenades, six sticks of illumination, three rubies and seven packets of healing herbs.



Entrance to the Bat Cave is west of Hall of Dungeons. "You are near the mouth of a large natural cave. Dim light from the [bold type]east[roman type] serves only to discover a passage leading further [bold type]west[roman type]." The room visibility of Entrance to the Bat Cave is -1.

In the Entrance to the Bat Cave are two bats.



Forking Passage is west of Entrance to the Bat Cave. "Here, the Bat Cave forks in three directions: a dimly lit passage going [bold type]east[roman type], and two darker passages going [bold type]northwest[roman type] and [bold type]northeast[roman type]." The room visibility of Forking Passage is -2.

In the Forking Passage is a giant mud crab.


Hall of Guano is northwest of Forking Passage. "A thick layer of bat guano covers the ground in this forking passage. You can go [bold type]north[roman type], [bold type]northeast[roman type] and [bold type]southeast[roman type]." The room visibility of Hall of Guano is -3.

In the Hall of Guano are three bats and a vampire bat. 


Dark Junction is north of Hall of Guano. "This passage is very dark. To the [bold type]north[roman type] lies an even darker part of the dungeon, while you can also go [bold type]northeast[roman type] and [bold type]south[roman type]." The room visibility of Dark Junction is -3.

In the Dark Junction are a mud crab and a scorpion.


Darkest Cave is north of Dark Junction. "This is the darkest cave you have ever seen, but you [italic type]sense[roman type] a treasure chest here. You can go [bold type]south[roman type]." The room visibility of Darkest Cave is -4.

In the Darkest Cave is a monstrous scorpion.

In the Darkest Cave is a treasure chest. It contains a diamond.


The Low Passage is northeast of Forking Passage. "You have to stoop to go through this passage. You can go [bold type]southwest[roman type] and [bold type]north[roman type]." The room visibility of Low Passage is -3.




Leaking Tunnel is north of The Low Passage. "Water falls on your head as you walk through this tunnel. A treasure chest sits quietly in one corner. You can go [bold type]south[roman type] and [bold type]west[roman type]." The room visibility of Leaking Tunnel is -3.

In the Leaking Tunnel are two bats and a giant mud crab.

In the Leaking Tunnel is a treasure chest. It contains healing herbs, a stick of illumination and two stick of guardings.



The Troll Cellar is west of Leaking Tunnel and northeast of Hall of Guano. "This is only called the Troll Cellar because this dungeon used to be part of a bigger game which also included a troll castle. You can go [bold type]east[roman type], [bold type]southwest[roman type] and [bold type]north[roman type]." The room visibility of Troll Cellar is -3.

In the Troll Cellar are a bat and a vampire bat.



Muddy Tunnel is north of The Troll Cellar and northeast of Dark Junction. "Mud sticks to the walls and the floor. You can go [bold type]north[roman type], [bold type]southwest[roman type] and [bold type]south[roman type]." The room visibility of Muddy Tunnel is -2.

In the Muddy Tunnel are two mud crabs.



Northern Cave Entrance is north of Muddy Tunnel. "You can go [bold type]south[roman type]. There is no outside to escape to." The room visibility of Northern Cave Entrance is -1.

In the Northern Cave Entrance is a snake.


Part - Dungeon 2 - Snakes and Boars

The forest is a dungeon. The Southern Forest Path, the Central Clearing, the Northern Forest Path, the Western Forest Path, the Eastern Forest Path, the Snake Pit and the Pool are in the Forest.

The forest cache is a treasure chest. The cache of the forest is the forest cache. In the forest cache are two sticks of guarding, ten rubies, three diamonds, one fire grenade, one stick of illumination and four packets of healing herbs.

The Southern Forest Path is northwest of the Hall of Dungeons. "A path in the forest. You can go [bold type]north[roman type] to the clearing, [bold type]west[roman type] to the snake pit, or [bold type]southeast[roman type] to the Hall of Dungeons."

In Southern Forest Path is a young boar.


The Central Clearing is north of the Southern Forest Path. "In the middle of a clearing stands a large treasure chest. Paths lead in all cardinal directions.".

In the Central Clearing is a treasure chest. It contains healing herbs and a ruby.


The Northern Forest Path is north of the Central Clearing. "A path in the forest. You can go [bold type]south[roman type] to the clearing or [bold type]east[roman type] to the pool."

In Northern Forest Path is a wild boar.


The Western Forest Path is west of the Central Clearing. "A path in the forest. You can go [bold type]east[roman type] to the clearing or [bold type]south[roman type] to the snake pit."

In Western Forest Path is a wild boar.


The Eastern Forest Path is east of the Central Clearing. "A path in the forest. You can go [bold type]west[roman type] to the clearing or [bold type]north[roman type] to the pool."

In Eastern Forest Path is a young boar.

The Snake Pit is west of Southern Forest Path and south of Western Forest Path. "Snakes often visit this hollow in the ground. You can go [bold type]east[roman type] or [bold type]north[roman type]."

In The Snake Pit are two snakes..

The Pool is north of the Eastern Forest Path and east of the Northern Forest Path. "The water comes to your knees. You can go [bold type]west[roman type] or [bold type]south[roman type]."

In the Pool are a water serpent and a diamond.



Part - Challenge 1 - The Troll

The Lair of the Troll is west of the Hall of Challenges. "A cavernous structure in which a bloodthirsty troll has made his lair. A crude closet stands in one corner."

Every turn when the player is in The Lair of the Troll for the first turn:
	say "'An intruder! Kill him, my hounds!', the troll screams.".

In The Lair of the Troll are a troll, a Rhodesian Ridgeback, a pit-bull and a German shepherd.

The crude closet is in The Lair of the Troll. It is a container. In the crude closet are a diamond and two rubies. Instead of opening the crude closet when a hostile alive monster is enclosed by the location: say "You'll have to defeat the monsters first!". The crude closet is closed and fixed in place.


Part - Challenge 2 - Separation

The Second Lair is north of the Hall of Challenges. "An ugly troll has been locked away in this room for quite some time now. [if the grating is switched on]A huge iron grating separates you from the troll.[otherwise]But you have released it![end if] There is also a big lever here; and you can go back [bold type]south[roman type]."

The sublocations of the Second lair is the Table of Two Divided Sublocations.

The ugly troll is a troll. The ugly troll is here. The sublocation of the ugly troll is 1.

The grating is here. It is a device. It is scenery. It is switched on. Understand "huge" and "iron" as the grating. Instead of examining the grating: say "[if switched on]It's good thing that this iron grating is here, for it is all that separates you from the troll[otherwise]The grating has disappeared into the ground[end if].".

The lever is here. It is scenery. Instead of examining the lever: say "You might try to pull it.".

Instead of pulling the lever when the grating is switched on:
	say "With an awful noise, the grating sinks into the ground. The troll immediately bounds towards you!";
	now the grating is switched off;
	now the sublocation of the ugly troll is 0.

Instead of pulling the lever when the grating is switched off:
	say "Hm, no. Nothing happens[if the ugly troll is alive]. That's unfortunate[end if].".


Part - Scenario 1 - Final confrontation

The Professor's Laboratory is west of the Hall of Scenarios. "A deep chasm runs through Professor Richardson's laboratory; [if the sublocation of Professor Richardson is the sublocation of the player]but that is no problem, as you are both on the same side.[otherwise]and he himself is on the far side, immune to your attacks.[end if] Three huge buttons are placed on [if the sublocation of the player is 0]this[otherwise]the far[end if] wall. A door leads back [bold type]east[roman type]."

The Sublocations of the Professor's Laboratory is the Table of Simple Range Separation Sublocations.

Before going west in The Hall of Scenarios for the first time:
	say "At last you have found the secret laboratory of Professor Richardson. You have chased the utterly brilliant but viciously evil scientist for months, from the deepest jungle of Brazil to the tops of the Alps, from secret Nazi bases to a Russian colony on the moon--but now you have found his lair, and he can escape you no longer. You can finally avenge your father.".

Before retreating in the Professor's Laboratory:
	if the sublocation of the player is 1, say "You are on the wrong side of the chasm!" instead;
	if the sublocation of Professor Richardson is 1 and Professor Richardson is alive begin;
		say "You run away.";
		move the player to the Hall of Scenarios;
		stop the action;
	end if;
	continue the action.


Section - The Scenery

In Professor's Laboratory is a thing called the buttons. The buttons are scenery and plural-named. Instead of examining the buttons: say "There are three buttons: a yellow button, a green button[if the green button is switched on] (which is pressed into the wall)[end if] and a red button[if the red button is switched on] (which is pressed into the wall)[end if].".

The yellow button is part of the buttons.

Before doing anything except examining with the yellow button:
	if the sublocation of the player is 1, say "You cannot reach it from here." instead.

Instead of examining the yellow button: say "It is just a big yellow button.".

Instead of pushing the yellow button:
	say "Apparently, it was a trap--the moment you press the yellow button, you feel an electric shock going through your body! 'Your ineptitude continues to surprise me,' the professor remarks.";
	deal 2 damage to the player.

The green button is part of the buttons. The green button is a device.

Instead of examining the green button: say "It is just a big green button[if the green button is switched on] (which is pressed into the wall)[end if].".

The red button is part of the buttons. The red button is a device.

Instead of examining the red button: say "It is just a big red button[if the red button is switched on] (which is pressed into the wall)[end if].".



Section - The Professor

Professor Richardson is a monster in The Professor's Laboratory.  "[if the blood of Professor Richardson is greater than 15]The professor looks at you with a superior, sardonic smile. His small crossbow is pointed at your chest.[otherwise if the blood of Professor Richardson is greater than 6]The professor looks at you with eyes full of hate. He will not stop before you die.[otherwise]You see fear in the professor's eyes.[end if]". Professor Richardson is proper-named. The sublocation of Professor Richardson  is 1. Professor Richardson  is ranged.

The melee of Professor Richardson is 5.
The blood of Professor Richardson is 20.

Professor Richardson is poisonous.

The poison chance of Professor Richardson is 3.
The minimum poison damage of Professor Richardson is 1.
The maximum poison damage of Professor Richardson is 4.
The poison time of Professor Richardson is 2.





Chapter 100 - Cheat Codes

Snuffing is an action applying to one thing. Understand "snuff [a person]" as snuffing.

Carry out snuffing:
	deal 10000 damage to the noun.

Does the player mean snuffing a killed person: it is very unlikely.

Armageddon is an action out of world. Understand "Armageddon" and "snuff all" as Armageddon.

Carry out Armageddon:
	say "BOOM!";
	repeat with the patient running through monsters begin;
		remove the patient from play;
	end repeat;
	
	
Becoming skillful is an action out of world. Understand "Merlin" as becoming skillful.

Carry out becoming skillful:
	say "You learn every first level skill.";
	repeat through the Table of Player Skills begin;
		if the lev entry is 1, change the have entry to 1;
	end repeat.
	
	
Replenishing is an action out of world. Understand "Arthur" as replenishing.

Carry out replenishing:
	say "Sure, cheater!";
	now the blood of the player is 20;
	now the zeal of the player is 10.


Gaboodling is an action out of world. Understand "excite" as gaboodling.

Carry out gaboodling:
	increase the excitement of the player;
	say "You are now [the excitement of the player].".


Gabeedling is an action out of world. Understand "deexcite" as gabeedling.

Carry out gabeedling:
	decrease the excitement of the player;
	say "You are now [the excitement of the player].".



	
